/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.snmp.propertypages.SnmpTrapGeneral;
import org.netxms.nxmc.modules.snmp.propertypages.SnmpTrapParameters;
import org.netxms.nxmc.modules.snmp.propertypages.SnmpTrapTransformation;
import org.netxms.nxmc.modules.snmp.views.helpers.SnmpTrapComparator;
import org.netxms.nxmc.modules.snmp.views.helpers.SnmpTrapLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapEditor
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(SnmpTrapEditor.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_TRAP_OID = 1;
    public static final int COLUMN_EVENT = 2;
    public static final int COLUMN_DESCRIPTION = 3;
    private static final String TABLE_CONFIG_PREFIX = "SnmpTrapEditor";
    private SortableTableViewer viewer;
    private NXCSession session;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Map<Long, SnmpTrap> traps = new HashMap();
    private SessionListener sessionListener;

    public SnmpTrapEditor() {
        super(LocalizationHelper.getI18n(SnmpTrapEditor.class).tr("SNMP Traps"), ResourceManager.getImageDescriptor((String)"icons/config-views/trapeditor.png"), "configuration.snmp-traps", true);
        this.session = Registry.getSession();
        this.sessionListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void createContent(Composite parent) {
        String[] columnNames = new String[]{this.i18n.tr("ID"), this.i18n.tr("OID"), this.i18n.tr("Event"), this.i18n.tr("Description")};
        int[] columnWidths = new int[]{70, 200, 100, 200};
        this.viewer = new SortableTableViewer(parent, columnNames, columnWidths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpTrapLabelProvider());
        this.viewer.setComparator((ViewerComparator)new SnmpTrapComparator());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.session.addListener(this.sessionListener);
        this.refresh();
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void dispose() {
        this.session.removeListener(this.sessionListener);
        super.dispose();
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateTrapList() {
        this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void deleteTraps() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected void editTrap() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        SnmpTrap trap = (SnmpTrap)selection.getFirstElement();
        if (this.showTrapConfigurationDialog(trap)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    protected void createTrap() {
        SnmpTrap trap = new SnmpTrap();
        trap.setEventCode(500);
        if (this.showTrapConfigurationDialog(trap)) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private boolean showTrapConfigurationDialog(SnmpTrap trap) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new SnmpTrapGeneral(trap)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("parameters", (IPreferencePage)new SnmpTrapParameters(trap)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("transformation", (IPreferencePage)new SnmpTrapTransformation(trap)));
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, this.i18n.tr("Edit SNMP Trap Mapping"));
        return dlg.open() == 0;
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

