/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.modules.snmp.shared.MibCache;

public class SnmpWalkFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private String filterString = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        SnmpValue vl = (SnmpValue)element;
        if (this.containsValue(vl)) {
            return true;
        }
        if (this.containsOid(vl)) {
            return true;
        }
        return this.containsOidText(vl);
    }

    public boolean containsValue(SnmpValue vl) {
        return vl.getValue().toLowerCase().contains(this.filterString.toLowerCase());
    }

    public boolean containsOid(SnmpValue vl) {
        return vl.getObjectId().toString().toLowerCase().contains(this.filterString.toLowerCase());
    }

    public boolean containsOidText(SnmpValue vl) {
        MibObject object = MibCache.findObject((String)vl.getName(), (boolean)false);
        if (object == null) {
            return false;
        }
        return object.getFullName().toLowerCase().contains(this.filterString.toLowerCase());
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString.toLowerCase();
    }
}

