/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.widgets.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpTrapLogRecord;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class SnmpTrapMonitorLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(SnmpTrapMonitorLabelProvider.class);
    private NXCSession session = Registry.getSession();

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SnmpTrapLogRecord record = (SnmpTrapLogRecord)element;
        switch (columnIndex) {
            case 0: {
                return DateFormatFactory.getDateTimeFormat().format(record.getTimestamp());
            }
            case 1: {
                return record.getSourceAddress().getHostAddress();
            }
            case 2: {
                AbstractObject object = this.session.findObjectById(record.getSourceNode());
                return object != null ? object.getObjectName() : this.i18n.tr("<unknown>");
            }
            case 3: {
                return record.getTrapObjectId();
            }
            case 4: {
                return record.getVarbinds();
            }
        }
        return null;
    }
}

