/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class CustomAttributeEditDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CustomAttributeEditDialog.class);
    private LabeledText nameText;
    private LabeledText valueText;
    private String name;
    private String value;

    public CustomAttributeEditDialog(Shell parentShell, String name, String value) {
        super(parentShell);
        this.name = name;
        this.value = value;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.name != null ? this.i18n.tr("Edit Custom Attribute") : this.i18n.tr("Add Custom Attribute"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameText = new LabeledText(dialogArea, 0);
        this.nameText.setLabel(this.i18n.tr("Name"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 400;
        this.nameText.setLayoutData((Object)gd);
        if (this.name != null) {
            this.nameText.setText(this.name);
        }
        this.valueText = new LabeledText(dialogArea, 0);
        this.valueText.setLabel(this.i18n.tr("Value"));
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.valueText.setLayoutData((Object)gd);
        if (this.value != null) {
            this.valueText.setText(this.value);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.nameText.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Custom attribute name cannot be empty"));
            return;
        }
        this.value = this.valueText.getText();
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }
}

