/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.reports.acl;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.client.users.UserGroup;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.reports.acl.AbstractAclReport;
import org.netxms.nxmc.modules.users.reports.acl.constants.GroupsSheetCells;
import org.netxms.nxmc.modules.users.reports.acl.constants.PermissionsSheetCells;
import org.netxms.nxmc.modules.users.reports.acl.constants.UsersSheetCells;
import org.xnap.commons.i18n.I18n;

public class AclReport
extends AbstractAclReport {
    private final I18n i18n = LocalizationHelper.getI18n(AclReport.class);

    public AclReport(String outputFileName) {
        super(outputFileName);
    }

    protected void generateUserSheet(XSSFWorkbook wb, XSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        XSSFSheet sheet = wb.getSheet(this.SHEET_USERS);
        XSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        XSSFCell cell = headerRow.createCell(UsersSheetCells.ID.ordinal());
        cell.setCellValue("ID");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.LOGIN.ordinal());
        cell.setCellValue("Login");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.STATUS.ordinal());
        cell.setCellValue("Status");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.FULL_NAME.ordinal());
        cell.setCellValue("Full Name");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.DESCRIPTION.ordinal());
        cell.setCellValue("Description");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.ORIGIN.ordinal());
        cell.setCellValue("Origin");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(UsersSheetCells.GROUPS.ordinal());
        cell.setCellValue("Member of");
        cell.setCellStyle((CellStyle)headerStyle);
        int columnIndex = UsersSheetCells.ACL_START_COLUMN.ordinal();
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("All Scheduled tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Asset Mgmt Attributes");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("SNMP Traps");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Delete Alarms");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Event Templates");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("EPP");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("External Integration");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Import Config");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Actions");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Agent Configs");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Agent Tunnels");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Geo Areas");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Image Library");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Mapping Tables");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Object Queries");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Packages");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Repositories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Scripts");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Server Files");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Sessions");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Summary Tables");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Tools");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage 2FA Methods");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Users");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Mobile Device Login");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Object Categories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Own Scheduled Tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Persistent Storage");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Read Server Files");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Reporting Server");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule File Upload");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule Maintenance");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule Scripts");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Send Notifications");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Server Config");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Server Console");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Setup TCP Proxy");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("SSH Keys");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("User Agent Notifications");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Unlink Issues");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("User Scheduled Tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View All Alarms");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Asset Change Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Audit Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View Event Templates");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Event Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View Repositories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Syslog");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("SNMP Trap Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Web Service Definitions");
        cell.setCellStyle((CellStyle)headerStyle);
        sheet.setColumnWidth(UsersSheetCells.ID.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.LOGIN.ordinal(), 3072);
        sheet.setColumnWidth(UsersSheetCells.STATUS.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.FULL_NAME.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(UsersSheetCells.ORIGIN.ordinal(), 2048);
        sheet.setColumnWidth(UsersSheetCells.GROUPS.ordinal(), 6144);
        AbstractUserObject[] userDatabaseObjects = this.session.getUserDatabaseObjects();
        Arrays.stream(userDatabaseObjects).filter(p -> p instanceof User).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            User user = (User)element;
            XSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(UsersSheetCells.ID.ordinal()).setCellValue((double)user.getId());
            row.createCell(UsersSheetCells.LOGIN.ordinal()).setCellValue(user.getName());
            row.createCell(UsersSheetCells.STATUS.ordinal()).setCellValue(user.isDisabled() ? "Disabled" : "Active");
            row.createCell(UsersSheetCells.FULL_NAME.ordinal()).setCellValue(user.getFullName());
            row.createCell(UsersSheetCells.DESCRIPTION.ordinal()).setCellValue(user.getDescription());
            row.createCell(UsersSheetCells.ORIGIN.ordinal()).setCellValue((user.getFlags() & 0x80) != 0 ? "LDAP" : "Local");
            boolean firstRow = true;
            for (int groupId : user.getGroups()) {
                XSSFRow groupRow;
                if (firstRow) {
                    groupRow = row;
                    firstRow = false;
                } else {
                    groupRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject group = this.session.findUserDBObjectById(groupId, null);
                groupRow.createCell(UsersSheetCells.GROUPS.ordinal()).setCellValue(group.getName());
            }
            int aclColumnIndex = UsersSheetCells.ACL_START_COLUMN.ordinal();
            this.createPermissionCell(row, aclColumnIndex++, 0x100000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 4L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 256L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 32L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 64L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x8000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x20000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 128L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 32768L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 524288L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x8000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 512L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 4096L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 8L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 2048L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 1L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 262144L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x100000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x80000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 65536L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x100000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 131072L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 2L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x10000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x40000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x10000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x40000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x4000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x4000000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 16384L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 16L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 1024L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x20000000L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 8192L, (AbstractUserObject)user);
            this.createPermissionCell(row, aclColumnIndex++, 0x80000000000L, (AbstractUserObject)user);
        });
    }

    protected void generateGroupsSheet(XSSFWorkbook wb, XSSFCellStyle headerStyle) {
        AtomicInteger rowNum = new AtomicInteger(0);
        XSSFSheet sheet = wb.getSheet(this.SHEET_GROUPS);
        XSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        XSSFCell cell = headerRow.createCell(GroupsSheetCells.ID.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("ID");
        cell = headerRow.createCell(GroupsSheetCells.NAME.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Name");
        cell = headerRow.createCell(GroupsSheetCells.DESCRIPTION.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Description");
        cell = headerRow.createCell(GroupsSheetCells.MEMBERS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Members");
        int columnIndex = GroupsSheetCells.ACL_START_COLUMN.ordinal();
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("All Scheduled tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Asset Mgmt Attributes");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Configure SNMP Traps");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Delete Alarms");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Event Templates");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("EPP");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("External Integration");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Import Config");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Actions");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Agent Configs");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Agent Tunnels");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Geo Areas");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Image Library");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Mapping Tables");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Object Queries");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Packages");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Repositories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Scripts");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Server Files");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Sessions");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Summary Tables");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Tools");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage 2FA Methods");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Manage Users");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Mobile Device Login");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Object Categories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Own Scheduled Tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Persistent Storage");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Read Server Files");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Reporting Server");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule File Upload");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule Maintenance");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Schedule Scripts");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Send Notifications");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Server Config");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Server Console");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Setup TCP Proxy");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("SSH Keys");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("User Agent Notifications");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Unlink Issues");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("User Scheduled Tasks");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View All Alarms");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Asset Change Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Audit Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View Event Templates");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Event Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("View Repositories");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Syslog");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("SNMP Trap Log");
        cell.setCellStyle((CellStyle)headerStyle);
        cell = headerRow.createCell(columnIndex++);
        cell.setCellValue("Web Service Definitions");
        cell.setCellStyle((CellStyle)headerStyle);
        sheet.setColumnWidth(GroupsSheetCells.ID.ordinal(), 3072);
        sheet.setColumnWidth(GroupsSheetCells.NAME.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.DESCRIPTION.ordinal(), 6144);
        sheet.setColumnWidth(GroupsSheetCells.MEMBERS.ordinal(), 4096);
        Arrays.stream(this.session.getUserDatabaseObjects()).filter(p -> p instanceof UserGroup).sorted(Comparator.comparing(AbstractUserObject::getName)).forEach(element -> {
            UserGroup group = (UserGroup)element;
            XSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(GroupsSheetCells.ID.ordinal()).setCellValue((double)group.getId());
            row.createCell(GroupsSheetCells.NAME.ordinal()).setCellValue(group.getName());
            row.createCell(GroupsSheetCells.DESCRIPTION.ordinal()).setCellValue(group.getDescription());
            boolean firstRow = true;
            for (int memberId : group.getMembers()) {
                XSSFRow memberRow;
                if (firstRow) {
                    memberRow = row;
                    firstRow = false;
                } else {
                    memberRow = sheet.createRow(rowNum.getAndIncrement());
                }
                AbstractUserObject member = this.session.findUserDBObjectById(memberId, null);
                if (member == null) continue;
                Object name = member instanceof User ? member.getName() : member.getName() + " (group)";
                memberRow.createCell(GroupsSheetCells.MEMBERS.ordinal()).setCellValue((String)name);
            }
            int aclColumnIndex = GroupsSheetCells.ACL_START_COLUMN.ordinal();
            this.createPermissionCell(row, aclColumnIndex++, 0x100000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 4L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 256L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 32L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 64L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x8000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x20000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 128L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 32768L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 524288L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x8000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 512L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 4096L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 8L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 2048L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x1000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 1L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 262144L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x100000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x80000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 65536L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x100000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x800000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 131072L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 2L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x200000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x10000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x400000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x40000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x10000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x40000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x4000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x4000000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 16384L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 16L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 1024L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x2000000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x20000000L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 8192L, (AbstractUserObject)group);
            this.createPermissionCell(row, aclColumnIndex++, 0x80000000000L, (AbstractUserObject)group);
        });
    }

    protected void generatePermissionsSheet(XSSFWorkbook wb, XSSFCellStyle headerStyle, List<AbstractAclReport.ObjectAccess> permissions) {
        AtomicInteger rowNum = new AtomicInteger(0);
        XSSFSheet sheet = wb.getSheet(this.SHEET_PERMISSIONS);
        XSSFRow headerRow = sheet.createRow(rowNum.getAndIncrement());
        XSSFCell cell = headerRow.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Object Name");
        cell = headerRow.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("User/Group name");
        cell = headerRow.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Inherit Access");
        cell = headerRow.createCell(PermissionsSheetCells.READ.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Read");
        cell = headerRow.createCell(PermissionsSheetCells.DELEGATED_READ.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Delegated Read");
        cell = headerRow.createCell(PermissionsSheetCells.MODIFY.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Modify");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_COMMENTS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Edit Comments");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_RESP_USERS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Edit Responsible Users");
        cell = headerRow.createCell(PermissionsSheetCells.DELETE.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Delete");
        cell = headerRow.createCell(PermissionsSheetCells.CONTROL.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Control");
        cell = headerRow.createCell(PermissionsSheetCells.MAINTENANCE.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Enter/Leave Maintenance");
        cell = headerRow.createCell(PermissionsSheetCells.CONFIGURE_AGENT.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Configure Agent");
        cell = headerRow.createCell(PermissionsSheetCells.READ_AGENT.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Read Agent");
        cell = headerRow.createCell(PermissionsSheetCells.READ_SNMP.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Read SNMP");
        cell = headerRow.createCell(PermissionsSheetCells.TAKE_SCREENSHOT.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Take Screenshots");
        cell = headerRow.createCell(PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Edit Maintenance Journal");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_CHILD_OBJECTS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Create Child Objects");
        cell = headerRow.createCell(PermissionsSheetCells.VIEW_ALARMS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("View Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACKNOWLEDGE_ALARMS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Acknowledge Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.TERMINATE_ALARMS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Terminate Alarms");
        cell = headerRow.createCell(PermissionsSheetCells.ACCESS_CONTROL.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Access Control");
        cell = headerRow.createCell(PermissionsSheetCells.CREATE_HELPDESK_ISSUES.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Create Helpdesk Issues");
        cell = headerRow.createCell(PermissionsSheetCells.DOWNLOAD_FILES.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Download Files");
        cell = headerRow.createCell(PermissionsSheetCells.UPLOAD_FILES.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Upload Files");
        cell = headerRow.createCell(PermissionsSheetCells.MANAGE_FILES.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Manage Files");
        cell = headerRow.createCell(PermissionsSheetCells.SEND_EVENTS.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Send Events");
        cell = headerRow.createCell(PermissionsSheetCells.PUSH_DATA.ordinal());
        cell.setCellStyle((CellStyle)headerStyle);
        cell.setCellValue("Push Data");
        sheet.setColumnWidth(PermissionsSheetCells.OBJECT_NAME.ordinal(), 20480);
        sheet.setColumnWidth(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal(), 4096);
        for (AbstractAclReport.ObjectAccess element : permissions) {
            XSSFRow row = sheet.createRow(rowNum.getAndIncrement());
            row.createCell(PermissionsSheetCells.OBJECT_NAME.ordinal()).setCellValue(element.name);
            row.createCell(PermissionsSheetCells.USER_OR_GROUP_NAME.ordinal()).setCellValue(element.userName);
            row.createCell(PermissionsSheetCells.INHERIT_ACCESS.ordinal()).setCellValue(element.inheritAccessRights ? this.i18n.tr("YES") : this.i18n.tr("NO"));
            this.createPermissionCell(row, PermissionsSheetCells.READ, 1, element);
            this.createPermissionCell(row, PermissionsSheetCells.DELEGATED_READ, 0x800000, element);
            this.createPermissionCell(row, PermissionsSheetCells.MODIFY, 2, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_COMMENTS, 0x200000, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_RESP_USERS, 0x400000, element);
            this.createPermissionCell(row, PermissionsSheetCells.DELETE, 8, element);
            this.createPermissionCell(row, PermissionsSheetCells.CONTROL, 256, element);
            this.createPermissionCell(row, PermissionsSheetCells.MAINTENANCE, 32768, element);
            this.createPermissionCell(row, PermissionsSheetCells.CONFIGURE_AGENT, 0x100000, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_AGENT, 65536, element);
            this.createPermissionCell(row, PermissionsSheetCells.READ_SNMP, 131072, element);
            this.createPermissionCell(row, PermissionsSheetCells.TAKE_SCREENSHOT, 262144, element);
            this.createPermissionCell(row, PermissionsSheetCells.EDIT_MAINTENANCE_JOURNAL, 524288, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_CHILD_OBJECTS, 4, element);
            this.createPermissionCell(row, PermissionsSheetCells.VIEW_ALARMS, 16, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACKNOWLEDGE_ALARMS, 64, element);
            this.createPermissionCell(row, PermissionsSheetCells.TERMINATE_ALARMS, 512, element);
            this.createPermissionCell(row, PermissionsSheetCells.ACCESS_CONTROL, 32, element);
            this.createPermissionCell(row, PermissionsSheetCells.CREATE_HELPDESK_ISSUES, 2048, element);
            this.createPermissionCell(row, PermissionsSheetCells.DOWNLOAD_FILES, 4096, element);
            this.createPermissionCell(row, PermissionsSheetCells.UPLOAD_FILES, 8192, element);
            this.createPermissionCell(row, PermissionsSheetCells.MANAGE_FILES, 16384, element);
            this.createPermissionCell(row, PermissionsSheetCells.SEND_EVENTS, 128, element);
            this.createPermissionCell(row, PermissionsSheetCells.PUSH_DATA, 1024, element);
        }
    }
}

