/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class NumericTextFieldValidator
implements TextFieldValidator {
    private final I18n i18n = LocalizationHelper.getI18n(NumericTextFieldValidator.class);
    private double min;
    private double max;
    private boolean wholeNumber;

    public NumericTextFieldValidator(long min, long max) {
        this.min = min;
        this.max = max;
        this.wholeNumber = true;
    }

    public NumericTextFieldValidator(double min, double max) {
        this.min = min;
        this.max = max;
        this.wholeNumber = false;
    }

    public boolean validate(String text) {
        try {
            double value = this.wholeNumber ? (double)Long.parseLong(text) : Double.parseDouble(text);
            return value >= this.min && value <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public String getErrorMessage(String text) {
        return this.wholeNumber ? this.i18n.tr("Must be whole number in range {0}..{1}", (Object)Long.toString((long)this.min), (Object)Long.toString((long)this.max)) : this.i18n.tr("Must be number between {0} and {1}", (Object)Double.toString(this.min), (Object)Double.toString(this.max));
    }
}

