/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.xnap.commons.i18n.I18n;

public class ObjectNameValidator
implements TextFieldValidator {
    private static char[] INVALID_CHARACTERS = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f'};
    private final I18n i18n = LocalizationHelper.getI18n(ObjectNameValidator.class);
    private boolean isEmpty = false;

    public boolean validate(String text) {
        this.isEmpty = text.trim().isEmpty();
        if (this.isEmpty) {
            return false;
        }
        for (char c : text.toCharArray()) {
            for (char tc : INVALID_CHARACTERS) {
                if (c != tc) continue;
                return false;
            }
        }
        return true;
    }

    public String getErrorMessage(String text) {
        return this.isEmpty ? this.i18n.tr("Name could not be empty") : this.i18n.tr("Invalid characters");
    }
}

