/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.Date;
import org.netxms.client.NXCException;
import org.netxms.client.TextOutputListener;

public class ServerOutputListener
implements TextOutputListener {
    private Object mutex = new Object();
    private StringBuilder buffer = new StringBuilder();
    private boolean completed = false;
    private Long streamId = 0L;
    private Date lastUpdateTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(String text) {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append(text);
            this.mutex.notifyAll();
        }
    }

    public void setStreamId(long streamId) {
        this.streamId = streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSuccess() {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.completed = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(Exception exception) {
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            this.buffer.append(exception instanceof NXCException ? exception.getMessage() : String.format("Internal error (%s)", exception.getClass().getName()));
            this.completed = true;
            this.mutex.notifyAll();
        }
    }

    public long getStreamId() {
        return this.streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readOutput() throws InterruptedException {
        String data;
        this.lastUpdateTime = new Date();
        Object object = this.mutex;
        synchronized (object) {
            while (this.buffer.length() == 0 && !this.completed) {
                this.mutex.wait();
            }
            data = this.buffer.toString();
            this.buffer = new StringBuilder();
        }
        return data;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }
}

