/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.netxms.base.annotations.Internal;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionNotification;

public class SessionToken {
    private UUID sessionHandle;
    private NXCSession session;
    @Internal
    private long activityTimestamp;
    @Internal
    private LinkedBlockingQueue<SessionNotification> notificationQueue = new LinkedBlockingQueue(8192);

    public SessionToken(NXCSession session) {
        this.sessionHandle = UUID.randomUUID();
        this.activityTimestamp = System.currentTimeMillis();
        this.session = session;
    }

    public void updateActivityTimestamp() {
        this.activityTimestamp = System.currentTimeMillis();
    }

    public UUID getSessionHandle() {
        return this.sessionHandle;
    }

    public NXCSession getSession() {
        return this.session;
    }

    public long getActivityTimestamp() {
        return this.activityTimestamp;
    }

    public void addNotificationToQueue(SessionNotification notification) {
        this.notificationQueue.offer(notification);
    }

    public List<SessionNotification> pollNotificationQueue(long timeout) throws InterruptedException {
        SessionNotification n;
        ArrayList<SessionNotification> notifications = new ArrayList<SessionNotification>();
        this.notificationQueue.drainTo(notifications);
        if (notifications.isEmpty() && (n = (SessionNotification)this.notificationQueue.poll(timeout, TimeUnit.SECONDS)) != null) {
            notifications.add(n);
        }
        this.updateActivityTimestamp();
        return notifications;
    }
}

