/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.netxms.nxmc.VideoServiceHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class VideoServiceHandler
implements ServiceHandler {
    private static final Logger logger = LoggerFactory.getLogger(VideoServiceHandler.class);
    public static final String ID = "videoServiceHandler";
    private static final String MULTIPART_BOUNDARY = "MULTIPART_NEXT_PART";
    private static Map<String, File> videoFiles = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String ch;
        File vf;
        String id = request.getParameter("id");
        Map map = videoFiles;
        synchronized (map) {
            vf = (File)videoFiles.get(id);
        }
        if (vf == null) {
            logger.error("Cannot find video file with ID {}", (Object)id);
            response.sendError(404);
            return;
        }
        int contentLength = (int)vf.length();
        ArrayList<Range> ranges = new ArrayList<Range>();
        String range = request.getHeader("Range");
        if (range != null) {
            if (!range.matches("^bytes=\\d*-\\d*(,\\d*-\\d*)*$")) {
                response.setHeader("Content-Range", "bytes */" + contentLength);
                response.sendError(416);
                return;
            }
            for (String part : range.substring(6).split(",")) {
                long end;
                String[] s = part.split("-");
                if (s.length != 2) continue;
                long start = s[0].isEmpty() ? 0L : Long.parseLong(s[0]);
                long l = end = s[1].isEmpty() ? (long)(contentLength - 1) : Long.parseLong(s[1]);
                if (start > end) {
                    response.setHeader("Content-Range", "bytes */" + contentLength);
                    response.sendError(416);
                    return;
                }
                ranges.add(new Range(this, start, end));
            }
        }
        if ((ch = request.getHeader("GetContentFeatures.DLNA.ORG")) != null && ch.equals("1")) {
            response.setHeader("ContentFeatures.DLNA.ORG", "DLNA.ORG_PN=MTG_MPEG4P2;DLNA.ORG_OP=01;DLNA.ORG_CI=0");
            response.setHeader("TransferMode.DLNA.ORG", "Streaming");
        }
        response.setHeader("Accept-Ranges", "bytes");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + vf.getName() + "\"");
        try (RandomAccessFile in = new RandomAccessFile(vf, "r");){
            ServletOutputStream out = response.getOutputStream();
            if (ranges.isEmpty()) {
                response.setContentType("video/mp4");
                response.setHeader("Content-Range", "bytes 0-" + (contentLength - 1) + "/" + contentLength);
                response.setHeader("Content-Length", Integer.toString(contentLength));
                VideoServiceHandler.copyBytes((RandomAccessFile)in, (OutputStream)out, (int)contentLength);
            } else if (ranges.size() == 1) {
                response.setStatus(206);
                response.setContentType("video/mp4");
                Range r = (Range)ranges.get(0);
                response.setHeader("Content-Range", "bytes " + r.start + "-" + r.end + "/" + contentLength);
                response.setHeader("Content-Length", Integer.toString(r.length));
                in.seek(r.start);
                VideoServiceHandler.copyBytes((RandomAccessFile)in, (OutputStream)out, (int)r.length);
            } else {
                response.setStatus(206);
                response.setContentType("multipart/byteranges; boundary=MULTIPART_NEXT_PART");
                for (Range r : ranges) {
                    out.println();
                    out.println("--MULTIPART_NEXT_PART");
                    out.println("Content-Type: video/mp4");
                    out.println("Content-Range: bytes " + r.start + "-" + r.end + "/" + contentLength);
                    in.seek(r.start);
                    VideoServiceHandler.copyBytes((RandomAccessFile)in, (OutputStream)out, (int)r.length);
                }
                out.println();
                out.println("--MULTIPART_NEXT_PART--");
            }
        }
    }

    private static void copyBytes(RandomAccessFile in, OutputStream out, int total) throws IOException {
        byte[] buffer = new byte[Math.min(total, 8192)];
        int len = in.read(buffer);
        int bytes = total;
        while (len != -1) {
            out.write(buffer, 0, Math.min(len, bytes));
            if ((bytes -= len) <= 0) break;
            len = in.read(buffer);
        }
    }

    public static String createDownloadUrl(String id) {
        StringBuilder url = new StringBuilder(RWT.getServiceManager().getServiceHandlerUrl("videoServiceHandler"));
        url.append("&id=");
        url.append(id);
        return RWT.getResponse().encodeURL(url.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVideoFile(String id, File localFile) {
        Map map = videoFiles;
        synchronized (map) {
            File vf = (File)videoFiles.get(id);
            if (vf != null) {
                vf.delete();
            }
            videoFiles.put(id, localFile);
        }
    }
}

