/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.DashboardComposite;
import org.netxms.nxmc.base.widgets.helpers.DashboardElementButton;

public abstract class Card
extends DashboardComposite {
    private static final int HEADER_MARGIN_HEIGHT = 6;
    private static final int HEADER_MARGIN_WIDTH = 8;
    private Composite header;
    private Label headerText;
    private Control clientArea;
    private Action doubleClickAction = null;
    private List<DashboardElementButton> buttons = new ArrayList(0);

    public Card(Composite parent, String text) {
        super(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.header = new Composite((Composite)this, 0);
        this.header.setData("org.eclipse.rap.rwt.customVariant", (Object)"CardHeader");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.header.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginHeight = 6;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 4;
        this.header.setLayout((Layout)layout);
        this.headerText = new Label(this.header, 0);
        this.headerText.setData("org.eclipse.rap.rwt.customVariant", (Object)"CardHeader");
        this.headerText.setText(text);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.headerText.setLayoutData((Object)gd);
        this.clientArea = this.createClientAreaInternal();
        this.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Control createClientAreaInternal() {
        Control ca = this.createClientArea((Composite)this);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        ca.setLayoutData((Object)gd);
        return ca;
    }

    protected void showClientArea(boolean show) {
        this.clientArea.setVisible(show);
        ((GridData)this.clientArea.getLayoutData()).exclude = !show;
        this.layout(true, true);
    }

    protected abstract Control createClientArea(Composite var1);

    public boolean setFocus() {
        return this.clientArea.setFocus();
    }

    public String getText() {
        return this.headerText.getText();
    }

    public void setText(String text) {
        this.headerText.setText(text);
    }

    protected Color getTitleBackground() {
        return this.header.getBackground();
    }

    protected void setTitleBackground(Color backgroundColor) {
        this.header.setBackground(backgroundColor);
        this.headerText.setBackground(backgroundColor);
        for (DashboardElementButton b : this.buttons) {
            b.getControl().setBackground(backgroundColor);
        }
    }

    protected Color getTitleColor() {
        return this.headerText.getForeground();
    }

    protected void setTitleColor(Color titleColor) {
        this.headerText.setForeground(titleColor);
    }

    public void addButton(DashboardElementButton button) {
        ++((GridLayout)this.header.getLayout()).numColumns;
        Label l = new Label(this.header, 0);
        l.setBackground(this.getTitleBackground());
        l.setImage(button.getImage());
        l.setToolTipText(button.getName());
        l.setCursor(this.getDisplay().getSystemCursor(21));
        l.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        l.setLayoutData((Object)gd);
        button.setControl((Control)l);
        this.buttons.add(button);
        this.layout(true, true);
    }

    public void updateButtons() {
        for (DashboardElementButton b : this.buttons) {
            Label l = (Label)b.getControl();
            l.setImage(b.getImage());
            l.setToolTipText(b.getName());
        }
    }

    public Action getDoubleClickAction() {
        return this.doubleClickAction;
    }

    public void setDoubleClickAction(Action doubleClickAction) {
        this.doubleClickAction = doubleClickAction;
    }

    public void replaceClientArea() {
        if (this.clientArea != null) {
            this.clientArea.dispose();
        }
        this.clientArea = this.createClientAreaInternal();
        this.layout();
    }
}

