/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.resources.SharedIcons;

public class CommandBox
extends Composite
implements DisposeListener {
    private List<Action> actions = new ArrayList();
    private Map<ImageDescriptor, Image> imageCache = new HashMap();
    private Cursor cursor;
    private Font font;

    public CommandBox(Composite parent, int style) {
        super(parent, style);
        this.setBackground(this.getDisplay().getSystemColor(25));
        this.cursor = new Cursor((Device)this.getDisplay(), 21);
        this.font = new Font((Device)this.getDisplay(), "Verdana", 9, 0);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        this.setLayout((Layout)layout);
        this.addDisposeListener((DisposeListener)this);
    }

    public void rebuild() {
        Collections.sort(this.actions, new /* Unavailable Anonymous Inner Class!! */);
        for (Action a : this.actions) {
            CLabel label = new CLabel((Composite)this, 16384);
            label.setText(a.getText());
            label.setImage(this.getImage(a));
            label.setCursor(this.cursor);
            label.setForeground(this.getDisplay().getSystemColor(24));
            label.setBackground(this.getDisplay().getSystemColor(25));
            label.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.layout();
    }

    private Image getImage(Action action) {
        Image img;
        ImageDescriptor d = action.getImageDescriptor();
        if (d != null) {
            img = (Image)this.imageCache.get(d);
            if (img == null) {
                img = d.createImage();
                this.imageCache.put(d, img);
            }
        } else {
            img = SharedIcons.IMG_EMPTY;
        }
        return img;
    }

    public void add(Action action, boolean doRebuild) {
        this.actions.add(action);
        if (doRebuild) {
            this.rebuild();
        }
    }

    public void deleteAll(boolean doRebuild) {
        this.actions.clear();
        for (Control c : this.getChildren()) {
            c.dispose();
        }
        if (doRebuild) {
            this.rebuild();
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        for (Image i : this.imageCache.values()) {
            i.dispose();
        }
        this.cursor.dispose();
        this.font.dispose();
    }
}

