/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.netxms.nxmc.tools.WidgetHelper;

public class FlatButton
extends Canvas {
    private static final int MARGIN_WIDTH = 5;
    private static final int MARGIN_HEIGHT = 3;
    private String text = "";
    private boolean withBorder = false;
    private Runnable action;

    public FlatButton(Composite parent, int style) {
        super(parent, 0);
        this.withBorder = (style & 0x800) != 0;
        this.addPaintListener((PaintListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doPaint(GC gc) {
        Rectangle clientArea = this.getClientArea();
        gc.fillRectangle(clientArea);
        Point s = gc.textExtent(this.text);
        gc.drawText(this.text, (clientArea.width - s.x) / 2, (clientArea.height - s.y) / 2, 8);
        if (this.withBorder) {
            gc.setLineWidth(2);
            gc.drawRectangle(clientArea);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 && hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point size = WidgetHelper.getTextExtent((Control)this, (String)this.text);
        size.x = wHint != -1 ? wHint : (size.x += 10);
        size.y = hHint != -1 ? hHint : (size.y += 6);
        return size;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Runnable getAction() {
        return this.action;
    }

    public void setAction(Runnable action) {
        this.action = action;
    }
}

