/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.netxms.nxmc.base.widgets.AbstractHyperlink;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;

public class Hyperlink
extends AbstractHyperlink {
    private String text;
    private static final String ELLIPSIS = "...";
    private boolean underlined;
    private String appToolTipText;

    public Hyperlink(Composite parent, int style) {
        super(parent, style);
        this.initAccessible();
    }

    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new /* Unavailable Anonymous Inner Class!! */);
        accessible.addAccessibleControlListener((AccessibleControlListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setUnderlined(boolean underlined) {
        this.underlined = underlined;
        this.redraw();
    }

    public boolean isUnderlined() {
        return this.underlined;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int innerHeight;
        this.checkWidget();
        int innerWidth = wHint;
        if (innerWidth != -1 && (innerWidth -= this.marginWidth * 2) < 0) {
            innerWidth = 0;
        }
        if ((innerHeight = hHint) != -1 && (innerHeight -= this.marginHeight * 2) < 0) {
            innerHeight = 0;
        }
        Point textSize = this.computeTextSize(innerWidth, innerHeight);
        int textWidth = textSize.x + 2 * this.marginWidth;
        int textHeight = textSize.y + 2 * this.marginHeight;
        if (wHint != -1) {
            textWidth = wHint;
        }
        if (hHint != -1) {
            textHeight = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, textWidth, textHeight);
        return new Point(trim.width, trim.height);
    }

    public String getText() {
        return this.text;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.appToolTipText;
    }

    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.appToolTipText = super.getToolTipText();
    }

    public void setText(String text) {
        this.text = text != null ? text : "";
        this.redraw();
    }

    protected void paintHyperlink(GC gc) {
        Rectangle carea = this.getClientArea();
        Rectangle bounds = new Rectangle(this.marginWidth, this.marginHeight, carea.width - this.marginWidth - this.marginWidth, carea.height - this.marginHeight - this.marginHeight);
        this.paintText(gc, bounds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintText(GC gc, Rectangle bounds) {
        gc.setFont(this.getFont());
        Color fg = this.isEnabled() ? this.getForeground() : new Color(gc.getDevice(), ColorConverter.blend((RGB)this.getBackground().getRGB(), (RGB)this.getForeground().getRGB(), (int)70));
        try {
            gc.setForeground(fg);
            if ((this.getStyle() & 0x40) != 0) {
                WidgetHelper.paintWrapText((GC)gc, (String)this.text, (Rectangle)bounds, (boolean)this.underlined);
            } else {
                Point totalSize = this.computeTextSize(-1, -1);
                boolean shortenText = false;
                if (bounds.width < totalSize.x) {
                    shortenText = true;
                }
                int textWidth = Math.min(bounds.width, totalSize.x);
                int textHeight = totalSize.y;
                String textToDraw = this.getText();
                if (shortenText) {
                    textToDraw = this.shortenText(gc, this.getText(), bounds.width);
                    if (this.appToolTipText == null) {
                        super.setToolTipText(this.getText());
                    }
                } else {
                    super.setToolTipText(this.appToolTipText);
                }
                gc.drawText(textToDraw, bounds.x, bounds.y, true);
                if (this.underlined) {
                    int descent = 2;
                    int lineY = bounds.y + textHeight - descent + 1;
                    gc.drawLine(bounds.x, lineY, bounds.x + textWidth, lineY);
                }
            }
        }
        finally {
            if (!this.isEnabled() && fg != null) {
                fg.dispose();
            }
        }
    }

    protected String shortenText(GC gc, String t, int width) {
        int min;
        if (t == null) {
            return null;
        }
        int w = gc.textExtent((String)ELLIPSIS).x;
        if (width <= w) {
            return t;
        }
        int l = t.length();
        int max = l / 2;
        int mid = (max + (min = 0)) / 2 - 1;
        if (mid <= 0) {
            return t;
        }
        while (min < mid && mid < max) {
            String s1 = t.substring(0, mid);
            String s2 = t.substring(l - mid, l);
            int l1 = gc.textExtent((String)s1).x;
            int l2 = gc.textExtent((String)s2).x;
            if (l1 + w + l2 > width) {
                max = mid;
                mid = (max + min) / 2;
                continue;
            }
            if (l1 + w + l2 < width) {
                min = mid;
                mid = (max + min) / 2;
                continue;
            }
            min = max;
        }
        if (mid == 0) {
            return t;
        }
        return t.substring(0, mid) + ELLIPSIS + t.substring(l - mid, l);
    }

    protected Point computeTextSize(int wHint, int hHint) {
        Point extent;
        GC gc = new GC((Drawable)this);
        gc.setFont(this.getFont());
        if ((this.getStyle() & 0x40) != 0 && wHint != -1) {
            extent = WidgetHelper.computeWrapSize((GC)gc, (String)this.getText(), (int)wHint);
        } else {
            extent = gc.textExtent(this.getText());
            if ((this.getStyle() & 0x40) == 0 && wHint != -1) {
                extent.x = wHint;
            }
        }
        gc.dispose();
        return extent;
    }
}

