/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.ServerClock;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class ServerClock
extends Composite {
    private static final int REFRESH_TIME = 30000;
    private I18n i18n = LocalizationHelper.getI18n(ServerClock.class);
    private Label time;
    private boolean showText;
    private boolean showTimeZone;
    private Runnable displayFormatChangeListener;

    public ServerClock(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.time = new Label((Composite)this, 0);
        this.time.setToolTipText(this.i18n.tr("Server time"));
        this.time.setData("org.eclipse.rap.rwt.customVariant", (Object)"ServerClock");
        this.createContextMenu();
        1 timer = new /* Unavailable Anonymous Inner Class!! */;
        timer.run();
    }

    private void createContextMenu() {
        PreferenceStore settings = PreferenceStore.getInstance();
        this.showText = settings.getAsBoolean("ServerClock.showText", false);
        this.showTimeZone = settings.getAsBoolean("ServerClock.showTimeZone", false);
        2 actionShowText = new /* Unavailable Anonymous Inner Class!! */;
        actionShowText.setChecked(this.showText);
        3 actionShowTimeZone = new /* Unavailable Anonymous Inner Class!! */;
        actionShowTimeZone.setChecked(this.showTimeZone);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)actionShowText);
        menuManager.add((IAction)actionShowTimeZone);
        this.setMenu(menuManager.createContextMenu((Control)this));
        this.time.setMenu(menuManager.createContextMenu((Control)this.time));
    }

    private void updateTimeDisplay() {
        DateFormat df = DateFormatFactory.getShortTimeFormat();
        NXCSession session = Registry.getSession();
        String tz = session.getServerTimeZone();
        df.setTimeZone(TimeZone.getTimeZone(tz.replaceAll("[A-Za-z]+([\\+\\-][0-9]+)(:[0-9]+)?.*", "GMT$1$2")));
        String timeText = this.showTimeZone ? df.format(new Date(session.getServerTime())) + " " + tz : df.format(new Date(session.getServerTime()));
        this.time.setText(this.showText ? String.format(this.i18n.tr("Server time is %s"), timeText) : timeText);
        this.getParent().layout(true, true);
    }

    public Runnable getDisplayFormatChangeListener() {
        return this.displayFormatChangeListener;
    }

    public void setDisplayFormatChangeListener(Runnable displayFormatChangeListener) {
        this.displayFormatChangeListener = displayFormatChangeListener;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.time.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.time.setForeground(color);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.time.setFont(font);
    }
}

