/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.Date;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.constants.TimeUnit;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.base.widgets.TimePeriodSelector;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.WidgetFactory;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TimePeriodSelector
extends Composite {
    private final I18n i18n = LocalizationHelper.getI18n(TimePeriodSelector.class);
    private Button radioBackFromNow;
    private Button radioFixedInterval;
    private Spinner timeRange;
    private Combo timeUnits;
    private DateTimeSelector timeFrom;
    private DateTimeSelector timeTo;

    public TimePeriodSelector(Composite parent, int style, TimePeriod period) {
        super(parent, style & 0xFFFFFCFF);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 4;
        layout.marginHeight = 4;
        layout.horizontalSpacing = 16;
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = (style & 0x200) != 0 ? 1 : 2;
        this.setLayout((Layout)layout);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.radioBackFromNow = new Button((Composite)this, 16);
        this.radioBackFromNow.setText(this.i18n.tr("Back from now"));
        this.radioBackFromNow.addSelectionListener((SelectionListener)listener);
        if ((style & 0x200) == 0) {
            this.radioFixedInterval = new Button((Composite)this, 16);
            this.radioFixedInterval.setText(this.i18n.tr("Fixed time frame"));
            this.radioFixedInterval.addSelectionListener((SelectionListener)listener);
        }
        Composite timeBackGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 4;
        layout.numColumns = 2;
        timeBackGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeBackGroup.setLayoutData((Object)gd);
        this.timeRange = WidgetHelper.createLabeledSpinner((Composite)timeBackGroup, (int)2048, (String)this.i18n.tr("Time interval"), (int)1, (int)10000, (Object)"WidgetHelper::default_layout_data");
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        this.timeUnits = WidgetHelper.createLabeledCombo((Composite)timeBackGroup, (int)8, (String)this.i18n.tr("Time units"), (Object)"WidgetHelper::default_layout_data");
        this.timeUnits.add(this.i18n.tr("Minutes"));
        this.timeUnits.add(this.i18n.tr("Hours"));
        this.timeUnits.add(this.i18n.tr("Days"));
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        if ((style & 0x200) != 0) {
            Composite filler = new Composite((Composite)this, 0);
            gd = new GridData();
            gd.heightHint = 11;
            filler.setLayoutData((Object)gd);
            this.radioFixedInterval = new Button((Composite)this, 16);
            this.radioFixedInterval.setText(this.i18n.tr("Fixed time frame"));
            this.radioFixedInterval.addSelectionListener((SelectionListener)listener);
        }
        Composite timeFixedGroup = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 4;
        timeFixedGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        timeFixedGroup.setLayoutData((Object)gd);
        WidgetFactory factory = (p, s) -> new DateTimeSelector(p, s);
        this.timeFrom = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)timeFixedGroup, (int)0, (WidgetFactory)factory, (String)this.i18n.tr("Time from"), (Object)"WidgetHelper::default_layout_data");
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        this.timeTo = (DateTimeSelector)WidgetHelper.createLabeledControl((Composite)timeFixedGroup, (int)0, (WidgetFactory)factory, (String)this.i18n.tr("Time to"), (Object)"WidgetHelper::default_layout_data");
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
        this.setTimePeriod(period);
    }

    public void setTimePeriod(TimePeriod period) {
        this.radioBackFromNow.setSelection(period.getTimeFrameType() == TimeFrameType.BACK_FROM_NOW);
        this.radioFixedInterval.setSelection(period.getTimeFrameType() == TimeFrameType.FIXED);
        this.timeRange.setSelection(period.getTimeRange());
        this.timeRange.setEnabled(this.radioBackFromNow.getSelection());
        this.timeUnits.select(period.getTimeUnit().getValue());
        this.timeUnits.setEnabled(this.radioBackFromNow.getSelection());
        this.timeFrom.setValue(period.getTimeFrom());
        this.timeFrom.setEnabled(this.radioFixedInterval.getSelection());
        this.timeTo.setValue(period.getTimeTo());
        this.timeTo.setEnabled(this.radioFixedInterval.getSelection());
    }

    public TimePeriod getTimePeriod() {
        TimePeriod tp = new TimePeriod();
        tp.setTimeFrameType(this.radioBackFromNow.getSelection() ? TimeFrameType.BACK_FROM_NOW : TimeFrameType.FIXED);
        tp.setTimeRange(this.timeRange.getSelection());
        tp.setTimeUnit(TimeUnit.getByValue((int)this.timeUnits.getSelectionIndex()));
        tp.setTimeFrom(this.timeFrom.getValue());
        tp.setTimeTo(this.timeTo.getValue());
        return tp;
    }

    public TimeFrameType getTimeFrameType() {
        return this.radioBackFromNow.getSelection() ? TimeFrameType.BACK_FROM_NOW : TimeFrameType.FIXED;
    }

    public int getTimeRange() {
        return this.timeRange.getSelection();
    }

    public TimeUnit getTimeUnit() {
        return TimeUnit.getByValue((int)this.timeUnits.getSelectionIndex());
    }

    public Date getTimeFrom() {
        return this.timeFrom.getValue();
    }

    public Date getTimeTo() {
        return this.timeTo.getValue();
    }

    public void setDefaults() {
        this.radioBackFromNow.setSelection(true);
        this.radioFixedInterval.setSelection(false);
        this.timeRange.setSelection(60);
        this.timeRange.setEnabled(true);
        this.timeUnits.select(0);
        this.timeUnits.setEnabled(true);
        this.timeFrom.setEnabled(false);
        this.timeTo.setEnabled(false);
    }
}

