/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import java.io.Serializable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.AgentExplorer;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.AgentDataTreeNode;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentDataTree;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentItemDetails;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.views.AdHocObjectView;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class AgentExplorer
extends AdHocObjectView {
    private I18n i18n = LocalizationHelper.getI18n(AgentExplorer.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_VALUE = 2;
    public static final int COLUMN_STATUS = 3;
    private AgentDataTree agentDataTree;
    private AgentItemDetails details;
    private Action actionQuery;
    private boolean toolView;

    public AgentExplorer(long objectId, long context, boolean toolView) {
        super(LocalizationHelper.getI18n(AgentExplorer.class).tr("Agent Explorer"), ResourceManager.getImageDescriptor((String)"icons/object-views/agent-explorer.png"), toolView ? "tools.agent-explorer" : "objects.agent-explorer", objectId, context, false);
        this.toolView = toolView;
    }

    protected AgentExplorer() {
        this(0L, 0L, false);
    }

    public View cloneView() {
        AgentExplorer view = (AgentExplorer)super.cloneView();
        view.toolView = this.toolView;
        return view;
    }

    public void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        if (this.toolView) {
            Group selectorArea = new Group(parent, 0);
            selectorArea.setText(this.i18n.tr("Context"));
            selectorArea.setLayout((Layout)new GridLayout());
            selectorArea.setLayoutData((Object)new GridData(4, 4, true, false));
            ObjectSelector objectSelector = new ObjectSelector((Composite)selectorArea, 0, new SelectorConfigurator().setShowClearButton(true).setShowLabel(false));
            objectSelector.setClassFilter(ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
            objectSelector.setObjectClass(Node.class);
            objectSelector.setLayoutData((Object)new GridData(4, 4, true, false));
            objectSelector.addModifyListener((ModifyListener & Serializable)e -> {
                AbstractObject object = objectSelector.getObject();
                this.setObjectId(object != null ? object.getObjectId() : 0L);
                this.setContext((Object)object);
                this.refreshTree();
            });
        }
        SashForm splitter = new SashForm(parent, 256);
        splitter.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.verticalIndent = this.toolView ? 3 : 0;
        splitter.setLayoutData((Object)gd);
        this.agentDataTree = new AgentDataTree((Composite)splitter, 2048);
        this.agentDataTree.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.details = new AgentItemDetails((Composite)splitter, 2048, this);
        splitter.setWeights(new int[]{30, 70});
        this.createActions();
        this.createTreeContextMenu();
        if (this.getObjectId() != 0L) {
            this.refreshTree();
        }
    }

    public void refresh() {
        this.refreshTree();
    }

    private void refreshTree() {
        if (this.getObjectId() == 0L) {
            this.agentDataTree.setInput(null, null, null);
            return;
        }
        long nodeId = this.getObjectId();
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void createActions() {
        this.actionQuery = new /* Unavailable Anonymous Inner Class!! */;
        this.actionQuery.setEnabled(false);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        super.fillLocalMenu(manager);
    }

    private void createTreeContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener & Serializable)m -> this.fillTreeContextMenu(m));
        Menu menu = menuMgr.createContextMenu((Control)this.agentDataTree.getTreeControl());
        this.agentDataTree.getTreeControl().setMenu(menu);
    }

    protected void fillTreeContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionQuery);
    }

    public void queryCurrentNode(String arguments) {
        if (this.getObject() == null) {
            return;
        }
        AgentDataTreeNode treeNode = this.agentDataTree.getSelection();
        if (treeNode == null || !treeNode.isLeaf()) {
            return;
        }
        long nodeId = this.getObjectId();
        4 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public String getFullName() {
        return this.toolView ? this.getName() : super.getFullName();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
    }
}

