/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.UserAgentNotification;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.UserAgentNotificationComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.UserAgentNotificationFilter;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.UserAgentNotificationLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class UserAgentNotificationView
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(UserAgentNotificationView.class);
    private static final String ID = "configuration.ua-notifications";
    public static final int COL_ID = 0;
    public static final int COL_OBJECTS = 1;
    public static final int COL_MESSAGE = 2;
    public static final int COL_IS_RECALLED = 3;
    public static final int COL_IS_STARTUP = 4;
    public static final int COL_START_TIME = 5;
    public static final int COL_END_TIME = 6;
    public static final int COL_CREATION_TIME = 7;
    public static final int COL_CREATED_BY = 8;
    private SortableTableViewer viewer;
    private UserAgentNotificationFilter filter;
    private Action actionShowAllOneTime;
    private Action actionShowAllOneScheduled;
    private Action actionRecall;
    private NXCSession session;

    public UserAgentNotificationView() {
        super(LocalizationHelper.getI18n(UserAgentNotificationView.class).tr("User Support Application Notifications"), ResourceManager.getImageDescriptor((String)"icons/config-views/user_agent_messages.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.session = Registry.getSession();
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Objects"), this.i18n.tr("Message"), this.i18n.tr("Is recalled"), this.i18n.tr("Is startup"), this.i18n.tr("Start time"), this.i18n.tr("End time"), this.i18n.tr("Creation time"), this.i18n.tr("Created by")};
        int[] widths = new int[]{80, 300, 300, 80, 80, 100, 100, 100, 100};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        UserAgentNotificationLabelProvider lebleProvider = new UserAgentNotificationLabelProvider(this.viewer);
        this.viewer.setLabelProvider((IBaseLabelProvider)lebleProvider);
        this.viewer.setComparator((ViewerComparator)new UserAgentNotificationComparator(lebleProvider));
        this.filter = new UserAgentNotificationFilter(lebleProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        PreferenceStore settings = PreferenceStore.getInstance();
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.filter.setShowAllOneTime(settings.getAsBoolean("UserAgentNotification.showAllOneTime", false));
        this.filter.setShowAllOneScheduled(settings.getAsBoolean("UserAgentNotification.showAllOneScheduled", false));
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    private void createActions() {
        this.actionShowAllOneTime = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowAllOneTime.setChecked(this.filter.isShowAllOneTime());
        this.actionShowAllOneScheduled = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowAllOneScheduled.setChecked(this.filter.isShowAllOneScheduled());
        this.actionRecall = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void recallMessage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() >= 1) {
            for (Object o : selection.toList()) {
                UserAgentNotification msg = (UserAgentNotification)o;
                new /* Unavailable Anonymous Inner Class!! */.start();
            }
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() >= 1) {
            boolean recallIsActive = true;
            for (Object o : selection.toList()) {
                if (!((UserAgentNotification)o).isRecalled() && ((UserAgentNotification)o).getStartTime().getTime() != 0L) continue;
                recallIsActive = false;
                break;
            }
            if (recallIsActive) {
                manager.add((IAction)this.actionRecall);
            }
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowAllOneTime);
        manager.add((IAction)this.actionShowAllOneScheduled);
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void notificationHandler(SessionNotification n) {
        switch (n.getCode()) {
            case 1041: {
                this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            }
        }
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

