/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.AgentTunnel;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;

public class TunnelListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color COLOR_BOUND = new Color((Device)Display.getDefault(), new RGB(26, 88, 0));
    private static final Color COLOR_UNBOUND = new Color((Device)Display.getDefault(), new RGB(199, 83, 0));

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AgentTunnel t = (AgentTunnel)element;
        switch (columnIndex) {
            case 12: {
                return t.getAgentId().toString();
            }
            case 13: {
                return t.isAgentProxy() ? "Yes" : "No";
            }
            case 11: {
                return t.getAgentVersion();
            }
            case 18: {
                if (t.getCertificateExpirationTime() == null || t.getCertificateExpirationTime().getTime() == 0L) {
                    return "";
                }
                return DateFormatFactory.getDateTimeFormat().format(t.getCertificateExpirationTime());
            }
            case 4: {
                return t.isBound() ? Integer.toString(t.getActiveChannelCount()) : "";
            }
            case 9: {
                return t.getHardwareIdAsText();
            }
            case 0: {
                return Integer.toString(t.getId());
            }
            case 3: {
                return t.getAddress().getHostAddress();
            }
            case 2: {
                return t.isBound() ? Registry.getSession().getObjectName(t.getNodeId()) : "";
            }
            case 7: {
                return t.getPlatformName();
            }
            case 14: {
                return t.isSnmpProxy() ? "Yes" : "No";
            }
            case 15: {
                return t.isSnmpTrapProxy() ? "Yes" : "No";
            }
            case 16: {
                return t.isSyslogProxy() ? "Yes" : "No";
            }
            case 10: {
                return t.getSerialNumber();
            }
            case 1: {
                return t.isBound() ? "Bound" : "Unbound";
            }
            case 8: {
                return t.getSystemInformation();
            }
            case 5: {
                return t.getSystemName();
            }
            case 6: {
                return t.getHostname();
            }
            case 17: {
                return t.isUserAgentInstalled() ? "Yes" : "No";
            }
            case 19: {
                if (t.getConnectionTime() == null || t.getConnectionTime().getTime() == 0L) {
                    return "";
                }
                return DateFormatFactory.getDateTimeFormat().format(t.getConnectionTime());
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        return ((AgentTunnel)element).isBound() ? COLOR_BOUND : COLOR_UNBOUND;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

