/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.widgets;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.Table;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.AgentExplorer;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.AgentDataTreeNode;
import org.netxms.nxmc.modules.agentmanagement.widgets.AgentItemDetails;
import org.xnap.commons.i18n.I18n;

public class AgentItemDetails
extends Composite {
    private I18n i18n = LocalizationHelper.getI18n(AgentItemDetails.class);
    private AgentExplorer view;
    private LabeledText name;
    private LabeledText type;
    private LabeledText description;
    private LabeledText arguments;
    private Composite valueContainer;
    private Text valueMetric;
    private TableViewer valueList;
    private AgentTableValueViewer valueTable;
    private Control currentValueControl;
    private Button queryButton;
    private AgentDataTreeNode currentNode;
    private AgentDataTreeNode.NodeType currentNodeType;

    public AgentItemDetails(Composite parent, int style, AgentExplorer view) {
        super(parent, style);
        this.view = view;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        this.setLayout((Layout)layout);
        Composite infoContainer = new Composite((Composite)this, 0);
        infoContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout infoLayout = new GridLayout();
        infoLayout.marginWidth = 0;
        infoLayout.marginHeight = 0;
        infoLayout.numColumns = 2;
        infoLayout.makeColumnsEqualWidth = true;
        infoContainer.setLayout((Layout)infoLayout);
        this.name = new LabeledText(infoContainer, 0, 2056);
        this.name.setLabel(this.i18n.tr("Name"));
        this.name.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.type = new LabeledText(infoContainer, 0, 2056);
        this.type.setLabel(this.i18n.tr("Type"));
        this.type.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.description = new LabeledText(infoContainer, 0, 2056);
        this.description.setLabel(this.i18n.tr("Description"));
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        new Label((Composite)this, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite queryContainer = new Composite((Composite)this, 0);
        queryContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout queryLayout = new GridLayout();
        queryLayout.numColumns = 2;
        queryLayout.marginWidth = 0;
        queryLayout.marginHeight = 0;
        queryContainer.setLayout((Layout)queryLayout);
        this.queryButton = new Button(queryContainer, 8);
        this.queryButton.setText(this.i18n.tr("&Query"));
        GridData gd = new GridData(16384, 1024, false, false);
        gd.widthHint = 90;
        this.queryButton.setLayoutData((Object)gd);
        this.queryButton.setEnabled(false);
        this.queryButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.arguments = new LabeledText(queryContainer, 0);
        this.arguments.setLabel(this.i18n.tr("Arguments"));
        this.arguments.setLayoutData((Object)new GridData(4, 1024, true, false));
        new Label((Composite)this, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.valueContainer = new Composite((Composite)this, 0);
        this.valueContainer.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridLayout valueLayout = new GridLayout();
        valueLayout.marginWidth = 0;
        valueLayout.marginHeight = 0;
        this.valueContainer.setLayout((Layout)valueLayout);
    }

    public void setNode(AgentDataTreeNode node) {
        this.currentNode = node;
        if (node == null) {
            this.name.setText("");
            this.type.setText("");
            this.description.setText("");
            this.queryButton.setEnabled(false);
            this.currentNodeType = null;
            if (this.currentValueControl != null) {
                this.currentValueControl.dispose();
                this.currentValueControl = null;
            }
            return;
        }
        this.name.setText(node.getName() != null ? node.getName() : node.getDisplayName());
        this.type.setText(node.getDataType() != null ? node.getDataType() : node.getType().name());
        this.description.setText(node.getDescription() != null ? node.getDescription() : "");
        this.queryButton.setEnabled(node.isLeaf());
        if (this.currentNodeType != node.getType()) {
            if (this.currentValueControl != null) {
                this.currentValueControl.dispose();
                this.currentValueControl = null;
            }
            switch (2.$SwitchMap$org$netxms$nxmc$modules$agentmanagement$views$helpers$AgentDataTreeNode$NodeType[node.getType().ordinal()]) {
                case 1: {
                    this.valueMetric = new Text(this.valueContainer, 2056);
                    this.valueMetric.setLayoutData((Object)new GridData(4, 128, true, false));
                    this.currentValueControl = this.valueMetric;
                    break;
                }
                case 2: {
                    this.valueList = new TableViewer(this.valueContainer, 67584);
                    this.valueList.setContentProvider((IContentProvider)new ArrayContentProvider());
                    this.valueList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
                    this.currentValueControl = this.valueList.getTable();
                    break;
                }
                case 3: {
                    this.valueTable = new AgentTableValueViewer(this.valueContainer, 2048, this.view);
                    this.valueTable.setLayoutData((Object)new GridData(4, 4, true, true));
                    this.currentValueControl = this.valueTable;
                    break;
                }
            }
            this.currentNodeType = node.getType();
            this.valueContainer.layout();
        }
    }

    public void setQueryResult(Object value, String status) {
        switch (2.$SwitchMap$org$netxms$nxmc$modules$agentmanagement$views$helpers$AgentDataTreeNode$NodeType[this.currentNodeType.ordinal()]) {
            case 1: {
                this.valueMetric.setText(value != null ? value.toString() : null);
                break;
            }
            case 2: {
                System.out.println("AgentItemDetails: setQueryResult for LIST type is called: " + String.valueOf(value));
                this.valueList.setInput(value);
                break;
            }
            case 3: {
                this.valueTable.setData((Table)value);
                this.valueTable.refresh(null);
                break;
            }
        }
    }
}

