/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.views.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.ai.AiAgentTask;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class AiTaskLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(AiTaskLabelProvider.class);
    public final String[] stateNames = new String[]{this.i18n.tr("Scheduled"), this.i18n.tr("Running"), this.i18n.tr("Completed"), this.i18n.tr("Failed")};
    private NXCSession session = Registry.getSession();
    private TableViewer viewer;

    public AiTaskLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getImage(element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AiAgentTask task = (AiAgentTask)element;
        switch (columnIndex) {
            case 1: {
                return task.getDescription();
            }
            case 6: {
                return task.getExplanation();
            }
            case 0: {
                return Long.toString(task.getId());
            }
            case 4: {
                return DateFormatFactory.getDateTimeFormat().format(task.getLastExecutionTime());
            }
            case 5: {
                return DateFormatFactory.getDateTimeFormat().format(task.getNextExecutionTime());
            }
            case 2: {
                int userId = task.getUserId();
                AbstractUserObject user = this.session.findUserDBObjectById(userId, (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + Long.toString(userId) + "]";
            }
            case 3: {
                try {
                    return this.stateNames[task.getState().getValue()];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    return this.i18n.tr("Unknown");
                }
            }
        }
        return null;
    }
}

