/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.widgets;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.autolink.AutolinkExtension;
import org.commonmark.ext.footnotes.FootnotesExtension;
import org.commonmark.ext.gfm.strikethrough.StrikethroughExtension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.ext.image.attributes.ImageAttributesExtension;
import org.commonmark.ext.ins.InsExtension;
import org.commonmark.ext.task.list.items.TaskListItemsExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.ai.AiFunctionCall;
import org.netxms.client.ai.AiQuestion;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.widgets.AiAssistantChatWidget;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.resources.ThemeEngine;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class AiAssistantChatWidget
extends Composite
implements SessionListener {
    private static final Logger logger = LoggerFactory.getLogger(AiAssistantChatWidget.class);
    private static final List<Extension> extensions = List.of(AutolinkExtension.create(), FootnotesExtension.builder().inlineFootnotes(true).build(), ImageAttributesExtension.create(), InsExtension.create(), TaskListItemsExtension.create(), StrikethroughExtension.create(), TablesExtension.create());
    private final I18n i18n = LocalizationHelper.getI18n(AiAssistantChatWidget.class);
    private NXCSession session;
    private View view;
    private long chatId;
    private long boundIncidentId;
    private boolean withContext;
    private Object context = null;
    private boolean contextChanged = false;
    private Browser chatBrowser;
    private CLabel contextName;
    private Text chatInput;
    private StringBuilder chatContent;
    private AiQuestion pendingQuestion;
    private String currentMessageId;
    private Image imageUnknownContext;
    private BaseObjectLabelProvider objectLabelProvider;
    private List<ChatMessage> messages;

    public AiAssistantChatWidget(Composite parent, int style, View view, long boundIncidentId, boolean withContext) {
        super(parent, style);
        this.view = view;
        this.boundIncidentId = boundIncidentId;
        this.withContext = withContext;
        this.session = Registry.getSession();
        this.chatContent = new StringBuilder();
        this.messages = new ArrayList();
        this.imageUnknownContext = ResourceManager.getImage((String)"icons/ai/unknown-context.png");
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.initializeHtmlTemplate();
        this.createContent();
        this.session.addListener((SessionListener)this);
        this.addDisposeListener((DisposeListener & Serializable)e -> {
            this.session.removeListener((SessionListener)this);
            this.imageUnknownContext.dispose();
            this.objectLabelProvider.dispose();
        });
    }

    private void initializeHtmlTemplate() {
        this.chatContent.append("<!DOCTYPE html>");
        this.chatContent.append("<html><head>");
        this.chatContent.append("<style>");
        this.chatContent.append("body { font: 14px \"Metropolis Regular\", \"Segoe UI\", \"Liberation Sans\", \".AppleSystemUIFont\", Verdana, Helvetica, sans-serif; margin: 0; padding: 10px; background-color: ");
        this.chatContent.append(ColorConverter.rgbToCss((RGB)ThemeEngine.getBackgroundColor((String)"AiAssistant.ChatView").getRGB()));
        this.chatContent.append("; }");
        this.chatContent.append(".message { margin-bottom: 15px; display: flex; }");
        this.chatContent.append(".user-message { justify-content: flex-end; }");
        this.chatContent.append(".assistant-message { justify-content: flex-start; }");
        this.chatContent.append(".bubble { max-width: 90%; padding: 8px 12px; border-radius: 8px; border: 1px solid; word-wrap: break-word; color: #202020; }");
        this.chatContent.append(".user-bubble { background-color: ");
        this.chatContent.append(ColorConverter.rgbToCss((RGB)ThemeEngine.getBackgroundColor((String)"AiAssistant.UserMessage").getRGB()));
        this.chatContent.append("; border-color: ");
        this.chatContent.append(ColorConverter.rgbToCss((RGB)ThemeEngine.getForegroundColor((String)"AiAssistant.UserMessage").getRGB()));
        this.chatContent.append("; }");
        this.chatContent.append(".assistant-bubble { background-color: ");
        this.chatContent.append(ColorConverter.rgbToCss((RGB)ThemeEngine.getBackgroundColor((String)"AiAssistant.AssistantMessage").getRGB()));
        this.chatContent.append("; border-color: ");
        this.chatContent.append(ColorConverter.rgbToCss((RGB)ThemeEngine.getForegroundColor((String)"AiAssistant.AssistantMessage").getRGB()));
        this.chatContent.append("; }");
        this.chatContent.append(".sender { font-size: 12px; margin-bottom: 5px; opacity: 0.7; }");
        this.chatContent.append(".question-card { background-color: #f8f9fa; border: 2px solid #0d6efd; border-radius: 12px; padding: 16px; margin: 15px 0; max-width: 80%; }");
        this.chatContent.append(".question-header { font-weight: bold; color: #0d6efd; margin-bottom: 10px; font-size: 13px; }");
        this.chatContent.append(".question-text { margin-bottom: 12px; }");
        this.chatContent.append(".question-context { background-color: #e9ecef; padding: 8px 12px; border-radius: 4px; font-family: monospace; margin-bottom: 12px; white-space: pre-wrap; }");
        this.chatContent.append(".question-buttons { display: flex; gap: 10px; margin-bottom: 8px; }");
        this.chatContent.append(".question-btn { padding: 8px 20px; border: none; border-radius: 6px; cursor: pointer; font-weight: 500; font-size: 14px; }");
        this.chatContent.append(".question-btn-positive { background-color: #198754; color: white; }");
        this.chatContent.append(".question-btn-positive:hover { background-color: #157347; }");
        this.chatContent.append(".question-btn-negative { background-color: #dc3545; color: white; }");
        this.chatContent.append(".question-btn-negative:hover { background-color: #bb2d3b; }");
        this.chatContent.append(".question-btn-option { background-color: #0d6efd; color: white; display: block; width: 100%; text-align: left; margin-bottom: 5px; }");
        this.chatContent.append(".question-btn-option:hover { background-color: #0b5ed7; }");
        this.chatContent.append(".question-timer { font-size: 12px; color: #6c757d; }");
        this.chatContent.append(".question-answered { opacity: 0.6; }");
        this.chatContent.append(".question-answered .question-buttons { display: none; }");
        this.chatContent.append(".question-btn:disabled { opacity: 0.5; cursor: not-allowed; }");
        this.chatContent.append(".function-status { display: flex; align-items: center; gap: 8px; color: #555; }");
        this.chatContent.append(".function-spinner { width: 16px; height: 16px; animation: spin 1s linear infinite; }");
        this.chatContent.append("@keyframes spin { from { transform: rotate(0deg); } to { transform: rotate(360deg); } }");
        this.chatContent.append("</style>");
        this.chatContent.append("<script>");
        this.chatContent.append("var questionTimers = {};");
        this.chatContent.append("var answeredQuestions = {};");
        this.chatContent.append("function answerQuestion(questionId, positive, selectedOption) {");
        this.chatContent.append("  if (answeredQuestions[questionId]) return;");
        this.chatContent.append("  answeredQuestions[questionId] = true;");
        this.chatContent.append("  if (questionTimers[questionId]) { clearInterval(questionTimers[questionId]); delete questionTimers[questionId]; }");
        this.chatContent.append("  var card = document.getElementById('question_' + questionId);");
        this.chatContent.append("  if (card) {");
        this.chatContent.append("    card.classList.add('question-answered');");
        this.chatContent.append("    var buttons = card.querySelectorAll('button');");
        this.chatContent.append("    buttons.forEach(function(btn) { btn.disabled = true; });");
        this.chatContent.append("    var timer = card.querySelector('.question-timer');");
        this.chatContent.append("    if (timer) { timer.textContent = 'Answered'; }");
        this.chatContent.append("  }");
        this.chatContent.append("  window.javaCallback(questionId, positive, selectedOption);");
        this.chatContent.append("}");
        this.chatContent.append("function startQuestionTimer(questionId, seconds) {");
        this.chatContent.append("  if (questionTimers[questionId]) return;");
        this.chatContent.append("  var timerEl = document.getElementById('timer_' + questionId);");
        this.chatContent.append("  if (!timerEl) return;");
        this.chatContent.append("  var remaining = seconds;");
        this.chatContent.append("  function updateTimer() {");
        this.chatContent.append("    var mins = Math.floor(remaining / 60);");
        this.chatContent.append("    var secs = remaining % 60;");
        this.chatContent.append("    timerEl.textContent = mins + ':' + (secs < 10 ? '0' : '') + secs;");
        this.chatContent.append("    if (remaining <= 0) {");
        this.chatContent.append("      clearInterval(questionTimers[questionId]);");
        this.chatContent.append("      delete questionTimers[questionId];");
        this.chatContent.append("      answerQuestion(questionId, false, -1);");
        this.chatContent.append("    }");
        this.chatContent.append("    remaining--;");
        this.chatContent.append("  }");
        this.chatContent.append("  updateTimer();");
        this.chatContent.append("  questionTimers[questionId] = setInterval(updateTimer, 1000);");
        this.chatContent.append("}");
        this.chatContent.append("</script>");
        this.chatContent.append("</head><body>");
        this.chatContent.append("<div id='chat-container'>");
        this.chatContent.append("</div>");
        this.chatContent.append("</body></html>");
    }

    private void createContent() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout((Layout)layout);
        this.chatBrowser = WidgetHelper.createBrowser((Composite)this, (int)0, null);
        this.chatBrowser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chatBrowser.addProgressListener((ProgressListener)new /* Unavailable Anonymous Inner Class!! */);
        new /* Unavailable Anonymous Inner Class!! */;
        this.addAssistantMessage(this.i18n.tr("Hello! I'm Iris, your AI assistant. I can help you with setting up your monitoring environment, day-to-day operations, and analyzing problems. Feel free to ask any questions!"));
        this.updateBrowserContent();
        Label separator = new Label((Composite)this, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite commandArea = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 8;
        layout.numColumns = 2;
        commandArea.setLayout((Layout)layout);
        commandArea.setLayoutData((Object)new GridData(4, 4, true, false));
        this.chatInput = new Text(commandArea, 0);
        this.chatInput.setMessage(this.i18n.tr("Write a message..."));
        this.chatInput.setLayoutData((Object)new GridData(4, 4, true, true));
        this.chatInput.setEnabled(false);
        this.chatInput.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        commandArea.setBackground(this.chatInput.getBackground());
        if (this.withContext) {
            Composite contextArea = new Composite(commandArea, 0);
            contextArea.setBackground(commandArea.getBackground());
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            contextArea.setLayout((Layout)layout);
            contextArea.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
            contextArea.moveAbove((Control)this.chatInput);
            Label contextLabel = new Label(contextArea, 0);
            contextLabel.setBackground(commandArea.getBackground());
            contextLabel.setText(this.i18n.tr("Context:"));
            contextLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.contextName = new CLabel(contextArea, 16384);
            this.contextName.setBackground(commandArea.getBackground());
            this.contextName.setText(this.i18n.tr("None"));
            this.contextName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Label sendButton = new Label(commandArea, 0);
        sendButton.setImage(SharedIcons.IMG_SEND);
        sendButton.setToolTipText(this.i18n.tr("Send"));
        sendButton.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        sendButton.setBackground(commandArea.getBackground());
        sendButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void createChatSession(boolean focusInput) {
        5 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getSubCode() != this.chatId) {
            return;
        }
        if (n.getCode() == 14) {
            this.getDisplay().asyncExec(() -> this.displayQuestion((AiQuestion)n.getObject()));
        } else if (n.getCode() == 16) {
            this.getDisplay().asyncExec(() -> this.updateFunctionStatus((AiFunctionCall)n.getObject()));
        }
    }

    private void updateFunctionStatus(AiFunctionCall functionCall) {
        int contentStart;
        int contentEnd;
        String searchPattern;
        if (this.currentMessageId == null) {
            return;
        }
        String spinnerSvg = "<svg class='function-spinner' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2'><circle cx='12' cy='12' r='10' stroke-opacity='0.25'/><path d='M12 2a10 10 0 0 1 10 10' stroke-linecap='round'/></svg>";
        String statusHtml = "<div class='function-status'>" + spinnerSvg + "<span>" + AiAssistantChatWidget.escapeHtml((String)functionCall.getDisplayName()) + "...</span></div>";
        String currentContent = this.chatContent.toString();
        int startPos = currentContent.indexOf(searchPattern = "id='" + this.currentMessageId + "'>");
        if (startPos != -1 && (contentEnd = currentContent.indexOf("</div></div>", contentStart = currentContent.indexOf("</div>", startPos) + 6)) != -1) {
            this.chatContent.replace(contentStart, contentEnd, statusHtml);
            this.updateBrowserContent();
        }
    }

    private void sendQuery() {
        String message = this.chatInput.getText().trim();
        this.chatInput.setText("");
        if (message.isEmpty()) {
            return;
        }
        this.addUserMessage(message);
        this.chatInput.setEnabled(false);
        this.currentMessageId = this.addThinkingMessage();
        String contextString = this.buildContextString();
        this.contextChanged = false;
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void addUserMessage(String message) {
        this.addMessage(message, true, null);
    }

    private String addAssistantMessage(String message) {
        String messageId = "msg_" + System.currentTimeMillis();
        this.addMessage(message, false, messageId);
        return messageId;
    }

    private String addThinkingMessage() {
        String messageId = "msg_" + System.currentTimeMillis();
        String spinnerSvg = "<svg class='function-spinner' viewBox='0 0 24 24' fill='none' stroke='currentColor' stroke-width='2'><circle cx='12' cy='12' r='10' stroke-opacity='0.25'/><path d='M12 2a10 10 0 0 1 10 10' stroke-linecap='round'/></svg>";
        String thinkingHtml = "<div class='function-status'>" + spinnerSvg + "<span>" + this.i18n.tr("Thinking...") + "</span></div>";
        this.messages.add(new ChatMessage(false, this.i18n.tr("Thinking...")));
        String messageHtml = "<div class='message assistant-message'><div class='bubble assistant-bubble' id='" + messageId + "'><div class='sender'>" + this.i18n.tr("AI Assistant") + "</div>" + thinkingHtml + "</div></div>";
        int insertPos = this.chatContent.lastIndexOf("</div></body></html>");
        this.chatContent.insert(insertPos, messageHtml);
        this.updateBrowserContent();
        return messageId;
    }

    private void addMessage(String message, boolean isUser, String messageId) {
        this.messages.add(new ChatMessage(isUser, message));
        String escapedMessage = this.prepareMessageText(message);
        String messageClass = isUser ? "user-message" : "assistant-message";
        String bubbleClass = isUser ? "user-bubble" : "assistant-bubble";
        String sender = isUser ? this.i18n.tr("User") : this.i18n.tr("AI Assistant");
        Object id = messageId != null ? " id='" + messageId + "'" : "";
        String messageHtml = "<div class='message " + messageClass + "'><div class='bubble " + bubbleClass + "'" + (String)id + "><div class='sender'>" + sender + "</div>" + escapedMessage + "</div></div>";
        int insertPos = this.chatContent.lastIndexOf("</div></body></html>");
        this.chatContent.insert(insertPos, messageHtml);
        this.updateBrowserContent();
    }

    private void updateMessage(String messageId, String newText) {
        int contentStart;
        int contentEnd;
        String searchPattern;
        if (!this.messages.isEmpty()) {
            ChatMessage lastMessage = (ChatMessage)this.messages.get(this.messages.size() - 1);
            if (!lastMessage.isUser) {
                this.messages.set(this.messages.size() - 1, new ChatMessage(false, newText));
            }
        }
        String escapedMessage = this.prepareMessageText(newText);
        String currentContent = this.chatContent.toString();
        int startPos = currentContent.indexOf(searchPattern = "id='" + messageId + "'>");
        if (startPos == -1 && this.currentMessageId != null && !this.currentMessageId.equals(messageId)) {
            searchPattern = "id='" + this.currentMessageId + "'>";
            startPos = currentContent.indexOf(searchPattern);
        }
        if (startPos != -1 && (contentEnd = currentContent.indexOf("</div></div>", contentStart = currentContent.indexOf("</div>", startPos) + 6)) != -1) {
            this.chatContent.replace(contentStart, contentEnd, escapedMessage);
            this.updateBrowserContent();
        }
    }

    private void removeMessage(String messageId) {
        int messageEnd;
        int messageStart;
        String searchPattern;
        String currentContent = this.chatContent.toString();
        int bubbleStart = currentContent.indexOf(searchPattern = "id='" + messageId + "'>");
        if (bubbleStart != -1 && (messageStart = currentContent.lastIndexOf("<div class='message", bubbleStart)) != -1 && (messageEnd = currentContent.indexOf("</div></div>", bubbleStart)) != -1) {
            this.chatContent.delete(messageStart, messageEnd += 12);
        }
    }

    private void updateBrowserContent() {
        this.chatBrowser.setText(this.chatContent.toString());
    }

    private String prepareMessageText(String text) {
        Object html;
        try {
            Parser parser = Parser.builder().extensions((Iterable)extensions).build();
            Node document = parser.parse(text);
            HtmlRenderer renderer = HtmlRenderer.builder().extensions((Iterable)extensions).build();
            html = renderer.render(document);
        }
        catch (Exception e) {
            logger.error("Exception in Markdown renderer", (Throwable)e);
            html = "<div class=\"notification notification-error\">Markdown rendering error</div><div>Original document source:</div><code>" + AiAssistantChatWidget.escapeHtml((String)text) + "</code></div></body></html>";
        }
        return html;
    }

    private static String escapeHtml(String text) {
        return text.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#x27;").replace("\n", "<br>");
    }

    public void clearChat() {
        this.chatContent.setLength(0);
        this.messages.clear();
        this.initializeHtmlTemplate();
        this.addAssistantMessage("Hello! I'm Iris, your AI assistant. I can help you with setting up your monitoring environment, day-to-day operations, and analyzing problems. Feel free to ask any questions!");
        this.contextChanged = true;
    }

    public void clearChatSession() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void displayQuestion(AiQuestion question) {
        this.pendingQuestion = question;
        this.chatInput.setEnabled(false);
        if (this.currentMessageId != null) {
            this.removeMessage(this.currentMessageId);
        }
        StringBuilder html = new StringBuilder();
        html.append("<div class='question-card' id='question_").append(question.getId()).append("'>");
        html.append("<div class='question-header'>Iris is asking:</div>");
        html.append("<div class='question-text'>").append(AiAssistantChatWidget.escapeHtml((String)question.getText())).append("</div>");
        String context = question.getContext();
        if (context != null && !context.isEmpty()) {
            html.append("<div class='question-context'>").append(AiAssistantChatWidget.escapeHtml((String)context)).append("</div>");
        }
        html.append("<div class='question-buttons'>");
        if (question.isMultipleChoice()) {
            List options = question.getOptions();
            for (int i = 0; i < options.size(); ++i) {
                html.append("<button class='question-btn question-btn-option' onclick='answerQuestion(").append(question.getId()).append(", true, ").append(i).append(")'>").append(AiAssistantChatWidget.escapeHtml((String)((String)options.get(i)))).append("</button>");
            }
        } else {
            html.append("<button class='question-btn question-btn-positive' onclick='answerQuestion(").append(question.getId()).append(", true, -1)'>").append(question.getPositiveLabel()).append("</button>");
            html.append("<button class='question-btn question-btn-negative' onclick='answerQuestion(").append(question.getId()).append(", false, -1)'>").append(question.getNegativeLabel()).append("</button>");
        }
        html.append("</div>");
        html.append("<div class='question-timer'>Expires in <span id='timer_").append(question.getId()).append("'>").append(question.getTimeoutSeconds() / 60).append(":").append(String.format("%02d", question.getTimeoutSeconds() % 60)).append("</span></div>");
        html.append("</div>");
        html.append("<script>startQuestionTimer(").append(question.getId()).append(", ").append(question.getTimeoutSeconds()).append(");</script>");
        int insertPos = this.chatContent.lastIndexOf("</div></body></html>");
        this.chatContent.insert(insertPos, html.toString());
        this.updateBrowserContent();
    }

    private void handleQuestionResponse(long questionId, boolean positive, int selectedOption) {
        if (this.pendingQuestion == null || this.pendingQuestion.getId() != questionId) {
            logger.warn("Received response for unknown question: " + questionId);
            return;
        }
        AiQuestion question = this.pendingQuestion;
        this.pendingQuestion = null;
        this.markQuestionAnswered(questionId);
        if (this.currentMessageId != null) {
            this.currentMessageId = this.addThinkingMessage();
        }
        8 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    private void markQuestionAnswered(long questionId) {
        int timerTextStart;
        int timerTextEnd;
        String timerSearch;
        int timerStart;
        String searchPattern;
        String currentContent = this.chatContent.toString();
        int cardStart = currentContent.indexOf(searchPattern = "id='question_" + questionId + "'");
        if (cardStart == -1) {
            return;
        }
        int divStart = currentContent.lastIndexOf("<div class='question-card'", cardStart);
        if (divStart == -1) {
            return;
        }
        String oldClass = "<div class='question-card'";
        String newClass = "<div class='question-card question-answered'";
        int classPos = currentContent.indexOf(oldClass, divStart);
        if (classPos != -1 && classPos < cardStart + 50) {
            this.chatContent.replace(classPos, classPos + oldClass.length(), newClass);
        }
        if ((timerStart = (currentContent = this.chatContent.toString()).indexOf(timerSearch = "id='timer_" + questionId + "'>")) != -1 && (timerTextEnd = currentContent.indexOf("</span>", timerTextStart = timerStart + timerSearch.length())) != -1) {
            int timerDivStart = currentContent.lastIndexOf("<div class='question-timer'>", timerStart);
            int timerDivEnd = currentContent.indexOf("</div>", timerStart);
            if (timerDivStart != -1 && timerDivEnd != -1) {
                this.chatContent.replace(timerDivStart, timerDivEnd + 6, "<div class='question-timer'>Answered</div>");
            }
        }
    }

    public Text getChatInput() {
        return this.chatInput;
    }

    public long getChatId() {
        return this.chatId;
    }

    public boolean setFocus() {
        return this.chatInput.setFocus();
    }

    public boolean hasMessagesToExport() {
        return this.messages.size() > 1;
    }

    public String exportAsMarkdown() {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        StringBuilder md = new StringBuilder();
        md.append("# AI Assistant Conversation\n");
        md.append("Exported: ").append(dateFormat.format(new Date())).append("\n\n");
        md.append("---\n\n");
        DateFormat df = DateFormatFactory.getDateTimeFormat();
        for (ChatMessage msg : this.messages) {
            String sender = msg.isUser ? "User" : "AI Assistant";
            md.append("**").append(sender).append(" at ").append(df.format(new Date(msg.timestamp))).append("**\n\n");
            md.append(msg.content).append("\n\n");
            md.append("---\n\n");
        }
        return md.toString();
    }

    public void setContext(Object context) {
        if (!this.withContext || this.context == context) {
            return;
        }
        this.contextChanged = true;
        this.context = context;
        if (context == null) {
            this.contextName.setText(this.i18n.tr("None"));
            this.contextName.setImage(null);
            return;
        }
        if (context instanceof AbstractObject) {
            AbstractObject object = (AbstractObject)context;
            this.contextName.setImage(this.objectLabelProvider.getImage((Object)object));
            this.contextName.setText(object.getNameWithAlias());
            return;
        }
        this.contextName.setImage(this.imageUnknownContext);
        this.contextName.setText(context.toString());
    }

    private String buildContextString() {
        if (this.context == null || !this.contextChanged) {
            return null;
        }
        if (this.context instanceof AbstractObject) {
            AbstractObject object = (AbstractObject)this.context;
            return "{\"type\":\"object\", \"object_name\":\"" + AiAssistantChatWidget.escapeForJson((String)object.getObjectName()) + "\", \"object_id\":" + object.getObjectId() + "}";
        }
        return this.context.toString();
    }

    private static String escapeForJson(String text) {
        return text.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }
}

