/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.ai.widgets.helpers;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.ai.AiMessage;
import org.netxms.client.constants.AiMessageStatus;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.ai.widgets.helpers.AiMessageListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class AiMessageListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private final I18n i18n = LocalizationHelper.getI18n(AiMessageListLabelProvider.class);
    private final String[] typeNames = new String[]{this.i18n.tr("Info"), this.i18n.tr("Alert"), this.i18n.tr("Approval")};
    private final String[] statusNames = new String[]{this.i18n.tr("Pending"), this.i18n.tr("Read"), this.i18n.tr("Approved"), this.i18n.tr("Rejected"), this.i18n.tr("Expired")};
    private final Image iconInformational = ResourceManager.getImage((String)"icons/ai/ai-message-info.png");
    private final Image iconAlert = ResourceManager.getImage((String)"icons/ai/ai-message-alert.png");
    private final Image iconApproval = ResourceManager.getImage((String)"icons/ai/ai-message-request.png");
    private NXCSession session = Registry.getSession();
    private Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");

    public void dispose() {
        this.iconInformational.dispose();
        this.iconAlert.dispose();
        this.iconApproval.dispose();
        super.dispose();
    }

    public String getTypeName(AiMessage message) {
        int value = message.getMessageType().getValue();
        if (value >= 0 && value < this.typeNames.length) {
            return this.typeNames[value];
        }
        return this.i18n.tr("Unknown");
    }

    public String getStatusName(AiMessage message) {
        int value = message.getStatus().getValue();
        if (value >= 0 && value < this.statusNames.length) {
            return this.statusNames[value];
        }
        return this.i18n.tr("Unknown");
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex > 0) {
            return null;
        }
        AiMessage message = (AiMessage)element;
        switch (1.$SwitchMap$org$netxms$client$constants$AiMessageType[message.getMessageType().ordinal()]) {
            case 1: {
                return this.iconAlert;
            }
            case 2: {
                return this.iconApproval;
            }
            case 3: {
                return this.iconInformational;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        AiMessage message = (AiMessage)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(message.getId());
            }
            case 1: {
                return this.getTypeName(message);
            }
            case 2: {
                return this.getStatusName(message);
            }
            case 3: {
                return message.getTitle();
            }
            case 4: {
                long objectId = message.getRelatedObjectId();
                if (objectId == 0L) {
                    return "";
                }
                AbstractObject object = this.session.findObjectById(objectId);
                return object != null ? object.getObjectName() : "[" + objectId + "]";
            }
            case 5: {
                return DateFormatFactory.getDateTimeFormat().format(message.getCreationTime());
            }
            case 6: {
                return DateFormatFactory.getDateTimeFormat().format(message.getExpirationTime());
            }
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        AiMessage message = (AiMessage)element;
        if (message.getStatus() == AiMessageStatus.PENDING) {
            return this.boldFont;
        }
        return null;
    }
}

