/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AssistantCommentDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(AssistantCommentDialog.class);
    private static final String CONFIG_PREFIX = "AssistantCommentDialog";
    private LabeledText textControl;
    private String text;

    public AssistantCommentDialog(Shell parentShell, String text) {
        super(parentShell);
        this.text = text;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("AI Assistant Comment"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger("AssistantCommentDialog.cx", 400), settings.getAsInteger("AssistantCommentDialog.cy", 350));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.textControl = new LabeledText(dialogArea, 0, 2882);
        this.textControl.setLabel(this.i18n.tr("Comment"));
        this.textControl.setText(this.text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        this.textControl.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("&Add as comment"), true);
        this.createButton(parent, 1, this.i18n.tr("Close"), false);
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        this.text = this.textControl.getText();
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("AssistantCommentDialog.cx", size.x);
        settings.set("AssistantCommentDialog.cy", size.y);
    }

    public String getText() {
        return this.text;
    }
}

