/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.events.AlarmCategory;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.alarms.dialogs.AlarmCategorySelectionDialog;
import org.xnap.commons.i18n.I18n;

public class AlarmCategorySelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(AlarmCategorySelector.class);
    private List<Long> categoryId;

    public AlarmCategorySelector(Composite parent, int style) {
        super(parent, style, new SelectorConfigurator().setSelectionButtonToolTip(LocalizationHelper.getI18n(AlarmCategorySelector.class).tr("Select category")));
        this.setText(this.i18n.tr("<none>"));
        this.categoryId = new ArrayList(0);
    }

    protected void selectionButtonHandler() {
        AlarmCategorySelectionDialog dlg = new AlarmCategorySelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.categoryId.clear();
            AlarmCategory[] categories = dlg.getSelectedCategories();
            if (categories != null && categories.length > 0) {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < categories.length; ++i) {
                    this.categoryId.add(categories[i].getId());
                    sb.append(categories[i].getName() + "; ");
                }
                this.setText(sb.toString());
            } else {
                this.setText(this.i18n.tr("<none>"));
            }
        }
    }

    public List<Long> getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(List<Long> categoryId) {
        if (this.categoryId.equals(categoryId)) {
            return;
        }
        if (categoryId != null && !categoryId.isEmpty()) {
            if (categoryId.get(0) == 0L) {
                this.setText(this.i18n.tr("<none>"));
            } else {
                List categories = Registry.getSession().findMultipleAlarmCategories(categoryId);
                if (categories != null) {
                    StringBuilder sb = new StringBuilder();
                    this.categoryId.clear();
                    for (AlarmCategory c : categories) {
                        sb.append(c.getName() + ";");
                        this.categoryId.add(c.getId());
                    }
                    this.setText(sb.toString());
                } else {
                    this.setText(this.i18n.tr("<unknown>"));
                }
            }
        } else {
            this.setText(this.i18n.tr("<none>"));
        }
        this.fireModifyListeners();
    }

    protected void clearButtonHandler() {
        if (this.categoryId == null || this.categoryId.isEmpty()) {
            return;
        }
        this.setText(this.i18n.tr("<none>"));
        this.fireModifyListeners();
    }
}

