/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.assetmanagement.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.asset.AssetAttribute;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.assetmanagement.widgets.AssetPropertyEditor;
import org.netxms.nxmc.tools.ObjectNameValidator;
import org.netxms.nxmc.tools.TextFieldValidator;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class CreateAssetDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(CreateAssetDialog.class);
    private Map<String, AssetAttribute> schema = Registry.getSession().getAssetManagementSchema();
    private LabeledText nameField;
    private LabeledText aliasField;
    private List<AssetPropertyEditor> propertyEditors = new ArrayList(this.schema.size());
    private String name;
    private String alias;
    private Map<String, String> properties;

    public CreateAssetDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Create Asset"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel(this.i18n.tr("Name"));
        this.nameField.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel(this.i18n.tr("Alias"));
        this.aliasField.getTextControl().setTextLimit(63);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.aliasField.setLayoutData((Object)gd);
        this.schema.values().stream().sorted((a1, a2) -> a1.getName().compareToIgnoreCase(a2.getName())).forEach(a -> this.createPropertyEditor(dialogArea, a));
        Label label = new Label(dialogArea, 0);
        label.setText(this.i18n.tr("* denotes mandatory fields"));
        gd = new GridData();
        gd.horizontalSpan = layout.numColumns;
        gd.verticalIndent = 8;
        label.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void createPropertyEditor(Composite dialogArea, AssetAttribute attribute) {
        AssetPropertyEditor editor = new AssetPropertyEditor(dialogArea, 0, attribute);
        GridData gd = new GridData();
        gd.widthHint = 300;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        editor.setLayoutData((Object)gd);
        this.propertyEditors.add(editor);
    }

    protected void okPressed() {
        boolean success = WidgetHelper.validateTextInput((LabeledText)this.nameField, (TextFieldValidator)new ObjectNameValidator());
        for (AssetPropertyEditor e : this.propertyEditors) {
            if (e.validateInput()) continue;
            success = false;
        }
        if (!success) {
            WidgetHelper.adjustWindowSize((Window)this);
            return;
        }
        this.alias = this.aliasField.getText().trim();
        this.name = this.nameField.getText().trim();
        this.properties = new HashMap();
        for (AssetPropertyEditor e : this.propertyEditors) {
            String value = e.getValue();
            if (value.isEmpty()) continue;
            this.properties.put(e.getAttribute().getName(), e.getValue());
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }
}

