/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.datacollection.widgets.DciTemplateSelectionWidget;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorElementEditDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorElementEditDialog.class);
    private StatusIndicatorConfig.StatusIndicatorElementConfig element;
    private LabeledText label;
    private Combo typeSelector;
    private Composite typeSpecificControl;
    private ObjectSelector objectSelector;
    private DciSelector dciSelector;
    private DciTemplateSelectionWidget templateDciWidget;
    private LabeledText tagEditor;
    private ObjectSelector drillDownObjectSelector;
    private String cachedDciName;

    public StatusIndicatorElementEditDialog(Shell parentShell, StatusIndicatorConfig.StatusIndicatorElementConfig element) {
        super(parentShell);
        this.element = element;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.element == null ? this.i18n.tr("Create Element") : this.i18n.tr("Edit Element"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        if (this.element == null) {
            this.element = new StatusIndicatorConfig.StatusIndicatorElementConfig();
        }
        this.label = new LabeledText(dialogArea, 0);
        this.label.setLabel("Label");
        this.label.setText(this.element.getLabel());
        GridData gd = new GridData(4, 4, true, false);
        gd.widthHint = 400;
        this.label.setLayoutData((Object)gd);
        this.typeSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)this.i18n.tr("Type"), (Object)"WidgetHelper::default_layout_data");
        this.typeSelector.add(this.i18n.tr("Object"));
        this.typeSelector.add(this.i18n.tr("DCI"));
        this.typeSelector.add(this.i18n.tr("DCI Template"));
        this.typeSelector.add(this.i18n.tr("Script"));
        this.typeSelector.select(this.element.getType());
        this.typeSelector.setLayoutData((Object)new GridData(4, 4, true, false));
        this.typeSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.typeSpecificControl = new Composite(dialogArea, 0);
        this.typeSpecificControl.setLayout((Layout)new FillLayout());
        this.typeSpecificControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.createTypeSpecificControls();
        this.drillDownObjectSelector = new ObjectSelector(dialogArea, 0, true);
        this.drillDownObjectSelector.setLabel(this.i18n.tr("Drill-down object"));
        this.drillDownObjectSelector.setObjectClass(AbstractObject.class);
        this.drillDownObjectSelector.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
        this.drillDownObjectSelector.setLayoutData((Object)new GridData(4, 4, true, false));
        this.drillDownObjectSelector.setObjectId(this.element.getDrillDownObjectId());
        return dialogArea;
    }

    private void createTypeSpecificControls() {
        for (Control c : this.typeSpecificControl.getChildren()) {
            c.dispose();
        }
        switch (this.typeSelector.getSelectionIndex()) {
            case 1: {
                this.dciSelector = new DciSelector(this.typeSpecificControl, 0);
                this.dciSelector.setLabel(this.i18n.tr("Data collection item"));
                this.dciSelector.setDciId(this.element.getObjectId(), this.element.getDciId());
                break;
            }
            case 2: {
                this.templateDciWidget = new DciTemplateSelectionWidget(this.typeSpecificControl, 0);
                this.templateDciWidget.setConfig(this.element.getTemplateConfig());
                break;
            }
            case 0: {
                this.objectSelector = new ObjectSelector(this.typeSpecificControl, 0, false);
                this.objectSelector.setLabel(this.i18n.tr("Object"));
                this.objectSelector.setObjectClass(AbstractObject.class);
                this.objectSelector.setObjectId(this.element.getObjectId());
                break;
            }
            case 3: {
                this.tagEditor = new LabeledText(this.typeSpecificControl, 0);
                this.tagEditor.setLabel(this.i18n.tr("Tag"));
                this.tagEditor.setText(this.element.getTag());
            }
        }
        if (this.getShell().isVisible()) {
            this.typeSpecificControl.getParent().layout(true, true);
            this.getShell().pack();
        }
    }

    protected void okPressed() {
        this.element.setLabel(this.label.getText().trim());
        this.element.setType(this.typeSelector.getSelectionIndex());
        this.element.setDrillDownObjectId(this.drillDownObjectSelector.getObjectId());
        switch (this.element.getType()) {
            case 1: {
                this.element.setObjectId(this.dciSelector.getNodeId());
                this.element.setDciId(this.dciSelector.getDciId());
                this.cachedDciName = this.dciSelector.getDciName();
                break;
            }
            case 2: {
                this.element.applyTemplateConfig(this.templateDciWidget.getConfig());
                break;
            }
            case 0: {
                this.element.setObjectId(this.objectSelector.getObjectId());
                break;
            }
            case 3: {
                this.element.setTag(this.tagEditor.getText().trim());
            }
        }
        super.okPressed();
    }

    public StatusIndicatorConfig.StatusIndicatorElementConfig getElement() {
        return this.element;
    }

    public String getCachedDciName() {
        return this.cachedDciName;
    }
}

