/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.dashboards.config.BarChartConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.ComparisonChartElement;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarChartElement
extends ComparisonChartElement {
    private static final Logger logger = LoggerFactory.getLogger(BarChartElement.class);
    private BarChartConfig elementConfig;

    public BarChartElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.elementConfig = (BarChartConfig)new Gson().fromJson(element.getData(), BarChartConfig.class);
        }
        catch (Exception e) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e);
            this.elementConfig = new BarChartConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLegendVisible(this.elementConfig.isShowLegend());
        chartConfig.setExtendedLegend(this.elementConfig.isExtendedLegend());
        chartConfig.setTransposed(this.elementConfig.isTransposed());
        chartConfig.setTranslucent(this.elementConfig.isTranslucent());
        chartConfig.setAutoScale(this.elementConfig.isAutoScale());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinYScaleValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxYScaleValue());
        chartConfig.setYAxisLabel(this.elementConfig.getYAxisLabel());
        this.chart = new Chart(this.getContentArea(), 0, ChartType.BAR, chartConfig, (View)view);
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        this.configureMetrics();
    }

    protected ChartDciConfig[] getDciList() {
        return this.elementConfig.getDciList();
    }
}

