/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeListener;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.TableRow;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.events.Event;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.EventMonitorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.EventMonitorElement;
import org.netxms.nxmc.modules.events.widgets.EventTraceWidget;
import org.netxms.nxmc.modules.events.widgets.helpers.HistoricalEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventMonitorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(EventMonitorElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(EventMonitorElement.class);
    private EventTraceWidget viewer;
    private EventMonitorConfig config;
    private final NXCSession session;
    private long lastLoadedEventId = 0L;
    private boolean historicalLoadComplete = false;
    private List<Event> pendingRealTimeEvents = new ArrayList();

    protected EventMonitorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = (EventMonitorConfig)new Gson().fromJson(element.getData(), EventMonitorConfig.class);
        }
        catch (Exception e2) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e2);
            this.config = new EventMonitorConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        this.session = Registry.getSession();
        this.viewer = new EventTraceWidget(this.getContentArea(), 0, (View)view);
        this.viewer.setRootObject(this.getEffectiveObjectId(this.config.getObjectId()));
        this.viewer.setFilterText(this.config.getFilter());
        this.viewer.setEventCodeFilter(this.config.getEventCodes());
        if (this.config.getMaxEvents() > 0) {
            this.viewer.setEventInterceptor(event -> {
                List list = this.pendingRealTimeEvents;
                synchronized (list) {
                    if (!this.historicalLoadComplete) {
                        if (event instanceof Event) {
                            this.pendingRealTimeEvents.add((Event)event);
                        }
                        return true;
                    }
                }
                return false;
            });
        }
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        this.addDisposeListener((DisposeListener & Serializable)e -> this.unsubscribe());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HistoricalEvent> loadHistoricalEvents() throws Exception {
        ArrayList<HistoricalEvent> events = new ArrayList<HistoricalEvent>();
        Log log = null;
        try {
            int[] eventCodes;
            AbstractObject object;
            long effectiveObjectId;
            log = this.session.openServerLog("EventLog");
            LogFilter filter = new LogFilter();
            if (this.config.getTimeRangeMinutes() > 0) {
                long now = System.currentTimeMillis() / 1000L;
                long rangeStart = now - (long)this.config.getTimeRangeMinutes() * 60L;
                filter.setColumnFilter("event_timestamp", new ColumnFilter(ColumnFilterType.GREATER, rangeStart));
            }
            if ((effectiveObjectId = this.getEffectiveObjectId(this.config.getObjectId())) != 0L && (object = this.session.findObjectById(effectiveObjectId)) != null) {
                filter.setColumnFilter("event_source", new ColumnFilter(EventMonitorElement.isEventSource((AbstractObject)object) ? ColumnFilterType.EQUALS : ColumnFilterType.CHILDOF, effectiveObjectId));
            }
            if ((eventCodes = this.config.getEventCodes()).length > 0) {
                if (eventCodes.length == 1) {
                    filter.setColumnFilter("event_code", new ColumnFilter(ColumnFilterType.EQUALS, (long)eventCodes[0]));
                } else {
                    ColumnFilter setFilter = new ColumnFilter();
                    setFilter.setOperation(ColumnFilterSetOperation.OR);
                    for (int code : eventCodes) {
                        setFilter.addSubFilter(new ColumnFilter(ColumnFilterType.EQUALS, (long)code));
                    }
                    filter.setColumnFilter("event_code", setFilter);
                }
            }
            ArrayList<OrderingColumn> ordering = new ArrayList<OrderingColumn>(1);
            ordering.add(new OrderingColumn("event_timestamp", "Time", true));
            filter.setOrderingColumns(ordering);
            log.query(filter);
            int maxToLoad = Math.min(this.config.getMaxEvents(), 500);
            Table data = log.retrieveData(0L, (long)maxToLoad);
            int idxId = log.getColumnIndex("event_id");
            int idxTimestamp = log.getColumnIndex("event_timestamp");
            int idxSource = log.getColumnIndex("event_source");
            int idxCode = log.getColumnIndex("event_code");
            int idxSeverity = log.getColumnIndex("event_severity");
            int idxMessage = log.getColumnIndex("event_message");
            int idxDciId = log.getColumnIndex("dci_id");
            for (TableRow row : data.getAllRows()) {
                events.add(new HistoricalEvent(row, idxId, idxTimestamp, idxSource, idxCode, idxSeverity, idxMessage, idxDciId));
            }
        }
        catch (Exception e) {
            logger.error("Error loading historical events", (Throwable)e);
        }
        finally {
            if (log != null) {
                try {
                    log.close();
                }
                catch (Exception e) {
                    logger.debug("Error closing log handle", (Throwable)e);
                }
            }
        }
        return events;
    }

    private static boolean isEventSource(AbstractObject object) {
        int objectClass = object.getObjectClass();
        return objectClass == 2 || objectClass == 14 || objectClass == 31 || objectClass == 37 || objectClass == 33;
    }

    private void unsubscribe() {
        2 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.setSystem(true);
        job.start();
        super.dispose();
    }
}

