/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.widgets;

import com.google.gson.Gson;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.StatusIndicatorConfig;
import org.netxms.nxmc.modules.dashboards.views.AbstractDashboardView;
import org.netxms.nxmc.modules.dashboards.views.DrilldownDashboardView;
import org.netxms.nxmc.modules.dashboards.widgets.DashboardControl;
import org.netxms.nxmc.modules.dashboards.widgets.ElementWidget;
import org.netxms.nxmc.modules.dashboards.widgets.StatusIndicatorElement;
import org.netxms.nxmc.modules.networkmaps.views.AdHocPredefinedMapView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.tools.ViewRefreshController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class StatusIndicatorElement
extends ElementWidget {
    private static final Logger logger = LoggerFactory.getLogger(StatusIndicatorElement.class);
    private final I18n i18n = LocalizationHelper.getI18n(StatusIndicatorElement.class);
    private NXCSession session = Registry.getSession();
    private StatusIndicatorConfig config;
    private ViewRefreshController refreshController;
    private boolean requireScriptRun = false;
    private boolean requireDataCollection = false;
    private List<StatusIndicatorElementWidget> elementWidgets = new ArrayList();
    private List<StatusIndicatorConfig.StatusIndicatorElementConfig> resolvedElements = new ArrayList();
    private static final int ELEMENT_HEIGHT = 36;

    protected StatusIndicatorElement(DashboardControl parent, DashboardElement element, AbstractDashboardView view) {
        super(parent, element, view);
        try {
            this.config = (StatusIndicatorConfig)new Gson().fromJson(element.getData(), StatusIndicatorConfig.class);
        }
        catch (Exception e2) {
            logger.error("Cannot parse dashboard element configuration", (Throwable)e2);
            logger.debug("Original XML:\n" + element.getData());
            this.config = new StatusIndicatorConfig();
        }
        this.processCommonSettings((DashboardElementConfig)this.config);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 16;
        layout.marginWidth = 16;
        layout.verticalSpacing = 16;
        layout.horizontalSpacing = 16;
        layout.numColumns = this.config.getNumColumns();
        layout.makeColumnsEqualWidth = true;
        this.getContentArea().setLayout((Layout)layout);
        for (StatusIndicatorConfig.StatusIndicatorElementConfig e3 : this.config.getElements()) {
            if (e3.getType() == 3) {
                this.requireScriptRun = true;
                continue;
            }
            if (e3.getType() != 1 && e3.getType() != 2) continue;
            this.requireDataCollection = true;
        }
        1 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
        this.startRefreshTimer();
        this.addDisposeListener((DisposeListener & Serializable)e -> this.refreshController.dispose());
    }

    private void createWidgets(List<StatusIndicatorConfig.StatusIndicatorElementConfig> resolved) {
        for (StatusIndicatorElementWidget w : this.elementWidgets) {
            w.dispose();
        }
        this.elementWidgets.clear();
        this.resolvedElements.clear();
        this.resolvedElements.addAll(resolved);
        for (StatusIndicatorConfig.StatusIndicatorElementConfig e : this.resolvedElements) {
            StatusIndicatorElementWidget widget = new StatusIndicatorElementWidget(this, this.getContentArea(), e);
            widget.setLayoutData((Object)new GridData(4, 4, true, false));
            this.elementWidgets.add(widget);
        }
        this.getContentArea().layout(true, true);
    }

    private void refreshData() {
        if (this.elementWidgets.isEmpty()) {
            return;
        }
        if (this.requireDataCollection || this.requireScriptRun) {
            2 job = new /* Unavailable Anonymous Inner Class!! */;
            job.setUser(false);
            job.start();
        } else {
            this.updateElements(null, null);
        }
    }

    private void updateElements(Map<String, String> scriptData, DciValue[] dciValues) {
        for (StatusIndicatorElementWidget w : this.elementWidgets) {
            StatusIndicatorConfig.StatusIndicatorElementConfig e = w.getElementConfig();
            switch (e.getType()) {
                case 0: {
                    AbstractObject object = this.session.findObjectById(this.getEffectiveObjectId(e.getObjectId()));
                    w.setStatus(object != null ? object.getStatus() : ObjectStatus.UNKNOWN);
                    break;
                }
                case 3: {
                    String value = scriptData.get(e.getTag());
                    if (value != null) {
                        try {
                            w.setStatus(ObjectStatus.getByValue((int)Integer.parseInt(value)));
                        }
                        catch (NumberFormatException ex) {
                            w.setStatus(ObjectStatus.UNKNOWN);
                        }
                        w.setVisible(true);
                        ((GridData)w.getLayoutData()).exclude = false;
                        break;
                    }
                    w.setVisible(false);
                    ((GridData)w.getLayoutData()).exclude = true;
                    break;
                }
                case 1: 
                case 2: {
                    boolean found = false;
                    if (dciValues != null) {
                        for (DciValue v : dciValues) {
                            if (v.getId() != e.getDciId()) continue;
                            Threshold t = v.getActiveThreshold();
                            w.setStatus(t != null ? ObjectStatus.getByValue((int)t.getCurrentSeverity().getValue()) : ObjectStatus.NORMAL);
                            found = true;
                            break;
                        }
                    }
                    if (found) break;
                    w.setStatus(ObjectStatus.UNKNOWN);
                }
            }
        }
        this.getContentArea().layout(true, true);
    }

    protected void startRefreshTimer() {
        this.refreshController = new ViewRefreshController((View)this.view, 15, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshData();
    }

    private static Pattern compilePattern(String pattern, boolean isRegex) {
        if (pattern == null || pattern.isEmpty()) {
            return null;
        }
        return isRegex ? Pattern.compile(pattern) : Pattern.compile(Pattern.quote(pattern));
    }

    private static boolean matchesPattern(Pattern pattern, String value) {
        return pattern != null && value != null && pattern.matcher(value).find();
    }

    private void openDrillDownObject(long drillDownObjectId) {
        if (this.view == null || drillDownObjectId == 0L) {
            return;
        }
        AbstractObject object = Registry.getSession().findObjectById(drillDownObjectId);
        if (object == null) {
            return;
        }
        if (object instanceof Dashboard) {
            Dashboard dashboard = (Dashboard)object;
            AbstractObject dashboardContext = this.view instanceof AbstractDashboardView ? this.view.getDashboardContext() : null;
            long dashboardContextId = dashboardContext != null ? dashboardContext.getObjectId() : 0L;
            long contextObjectId = this.view instanceof ObjectView ? this.view.getObjectId() : 0L;
            this.view.openView((View)new DrilldownDashboardView(dashboard, dashboardContextId, contextObjectId));
        } else if (object instanceof NetworkMap) {
            NetworkMap map = (NetworkMap)object;
            long contextObjectId = this.view instanceof ObjectView ? this.view.getObjectId() : 0L;
            this.view.openView((View)new AdHocPredefinedMapView(contextObjectId, map));
        }
    }
}

