/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.SummaryTablesCache;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SelectSummaryTableDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(SelectSummaryTableDialog.class);
    private TableViewer viewer;
    private DciSummaryTableDescriptor table;

    public SelectSummaryTableDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(this.i18n.tr("Select DCI Summary Table"));
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        new Label(dialogArea, 0).setText(this.i18n.tr("Available DCI summary tables"));
        this.viewer = new TableViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setInput((Object)SummaryTablesCache.getInstance().getTables());
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("You must select summary table from list and then press OK."));
            return;
        }
        this.table = (DciSummaryTableDescriptor)selection.getFirstElement();
        super.okPressed();
    }

    public DciSummaryTableDescriptor getTable() {
        return this.table;
    }
}

