/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.WebServiceDefinition;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.modules.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectWebServiceDlg;
import org.netxms.nxmc.tools.MessageDialogHelper;

public class SelectWebServiceDlg
extends Dialog
implements IParameterSelectionDialog {
    boolean multiSelection;
    private TableViewer viewer;
    private List<WebServiceDefinition> selection;

    public SelectWebServiceDlg(Shell parentShell, boolean multiSelection) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.multiSelection = multiSelection;
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        Point location = this.getShell().getLocation();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set("SelectWebServiceDlg.location", location);
        settings.set("SelectWebServiceDlg.size", size);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Web Service Defenition Selection");
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsPoint("SelectWebServiceDlg.size", 400, 250));
        newShell.setLocation(settings.getAsPoint("SelectWebServiceDlg.location", 100, 100));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 0x10800 | (this.multiSelection ? 2 : 0));
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 400;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.getWebServiceDefinitions();
        return dialogArea;
    }

    private void getWebServiceDefinitions() {
        NXCSession session = Registry.getSession();
        3 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection viewerSelection = this.viewer.getStructuredSelection();
        if (viewerSelection.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Web service definition should be selected");
            return;
        }
        this.selection = new ArrayList();
        for (Object o : viewerSelection.toList()) {
            this.selection.add((WebServiceDefinition)o);
        }
        this.saveSettings();
        super.okPressed();
    }

    public List<WebServiceDefinition> getSelection() {
        return this.selection;
    }

    public String getParameterName() {
        return ((WebServiceDefinition)this.selection.get(0)).getName() + ":";
    }

    public String getParameterDescription() {
        return ((WebServiceDefinition)this.selection.get(0)).getName();
    }

    public DataType getParameterDataType() {
        return DataType.STRING;
    }

    public String getInstanceColumn() {
        return "";
    }
}

