/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.GraphDefinition;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.DataSourceEditDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectDciDialog;
import org.netxms.nxmc.modules.datacollection.propertypages.helpers.DciListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class DataSources
extends PreferencePage {
    private final I18n i18n = LocalizationHelper.getI18n(DataSources.class);
    public static final int COLUMN_POSITION = 0;
    public static final int COLUMN_NODE = 1;
    public static final int COLUMN_METRIC = 2;
    public static final int COLUMN_LABEL = 3;
    public static final int COLUMN_COLOR = 4;
    private GraphDefinition config;
    private DciListLabelProvider labelProvider;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<ChartDciConfig> dciList = null;
    private boolean graphIsTemplate = false;
    private boolean saveToDatabase;

    public DataSources(GraphDefinition settings, boolean saveToDatabase) {
        super("Data Source");
        this.config = settings;
        this.saveToDatabase = saveToDatabase;
    }

    protected Control createContents(Composite parent) {
        this.graphIsTemplate = this.config.isTemplate();
        Composite dialogArea = new Composite(parent, 0);
        this.dciList = new ArrayList();
        for (ChartDciConfig dci : this.config.getDciList()) {
            this.dciList.add(new ChartDciConfig(dci));
        }
        this.labelProvider = new DciListLabelProvider(this.dciList);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{this.i18n.tr("Pos."), this.i18n.tr("Node"), this.i18n.tr("Parameter"), this.i18n.tr("Label"), this.i18n.tr("Color")};
        int[] columnWidths = new int[]{40, 130, 200, 150, 50};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.disableSorting();
        this.viewer.setInput((Object)this.dciList.toArray());
        this.labelProvider.resolveDciNames((Collection)this.dciList, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        gridData.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gridData);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("&Down"));
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gridData);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton.setEnabled(false);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(this.i18n.tr("Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton.setEnabled(false);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addItem() {
        SelectDciDialog dlg = new SelectDciDialog(this.getShell(), 0L);
        if (dlg.open() == 0) {
            List selection = dlg.getSelection();
            ArrayList<ChartDciConfig> select = new ArrayList<ChartDciConfig>();
            for (DciValue item : selection) {
                ChartDciConfig dci = new ChartDciConfig(item);
                this.labelProvider.addCacheEntry(dci.nodeId, dci.dciId, dci.dciDescription);
                select.add(dci);
                this.dciList.add(dci);
            }
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(select));
        }
    }

    private void editItem() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        ChartDciConfig dci = (ChartDciConfig)selection.getFirstElement();
        if (dci == null) {
            return;
        }
        DataSourceEditDlg dlg = new DataSourceEditDlg(this.getShell(), dci, this.graphIsTemplate);
        if (dlg.open() == 0) {
            this.viewer.update((Object)dci, null);
        }
    }

    private void deleteItems() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.dciList.remove(o);
        }
        this.viewer.setInput((Object)this.dciList.toArray());
    }

    private void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dciList, index - 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    private void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.dciList.indexOf(element = selection.getFirstElement())) < this.dciList.size() - 1 && index >= 0) {
            Collections.swap(this.dciList, index + 1, index);
            this.viewer.setInput((Object)this.dciList.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void applyChanges(boolean isApply) {
        if (!this.isControlCreated()) {
            return;
        }
        this.config.setDciList(this.dciList.toArray(new ChartDciConfig[this.dciList.size()]));
        if (this.saveToDatabase && isApply) {
            this.setValid(false);
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

