/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.base.widgets.RoundedLabel;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.HistoricalDataSelectionDialog;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.HistoricalDataLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class HistoricalDataView
extends ViewWithContext {
    private final I18n i18n = LocalizationHelper.getI18n(HistoricalDataView.class);
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_FORMATTED_VALUE = 2;
    public static final int COLUMN_RAW_VALUE = 3;
    private NXCSession session = Registry.getSession();
    private long contextId;
    private long ownerId;
    private long dciId;
    private String fullName;
    private String nodeName;
    private String tableName;
    private String instance;
    private String column;
    private SortableTableViewer viewer;
    private Date timeFrom = null;
    private Date timeTo = null;
    private int recordLimit = 4096;
    private boolean updateInProgress = false;
    private Action actionSelectRange;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionDeleteDciEntry;
    private Composite infoArea;
    private Label labelDciId;
    private Label labelDciName;
    private RoundedLabel labelDciDescription;
    private Label labelDciUnits;
    private Label labelTableInfo;

    private static String buildId(AbstractObject object, long dciId, String tableName, String instance, String column) {
        StringBuilder sb = new StringBuilder("HistoricalGraphView");
        if (object != null) {
            sb.append('#');
            sb.append(object.getObjectId());
        }
        sb.append('#');
        sb.append(dciId);
        if (tableName != null) {
            sb.append('#');
            sb.append(tableName);
        }
        if (instance != null) {
            sb.append('#');
            sb.append(instance);
        }
        if (column != null) {
            sb.append('#');
            sb.append(column);
        }
        return sb.toString();
    }

    public HistoricalDataView(AbstractObject contextObject, long ownerId, long dciId) {
        this(contextObject, ownerId, dciId, null, null, null);
    }

    public HistoricalDataView(AbstractObject contextObject, long ownerId, long dciId, String tableName, String instance, String column) {
        super(LocalizationHelper.getI18n(HistoricalDataView.class).tr("Historical Data"), ResourceManager.getImageDescriptor((String)"icons/object-views/history-view.png"), HistoricalDataView.buildId((AbstractObject)contextObject, (long)dciId, (String)tableName, (String)instance, (String)column), true);
        this.contextId = contextObject.getObjectId();
        this.ownerId = ownerId;
        this.dciId = dciId;
        this.tableName = tableName;
        this.instance = instance;
        this.column = column;
        this.nodeName = contextObject.getObjectName();
        String dciName = tableName == null ? Long.toString(dciId) : tableName;
        this.fullName = this.nodeName + ": [" + dciName + "]";
        this.setName(dciName);
    }

    public View cloneView() {
        HistoricalDataView view = (HistoricalDataView)super.cloneView();
        view.contextId = this.contextId;
        view.dciId = this.dciId;
        view.ownerId = this.ownerId;
        view.tableName = this.tableName;
        view.instance = this.instance;
        view.column = this.column;
        view.fullName = this.fullName;
        view.nodeName = this.nodeName;
        view.timeFrom = this.timeFrom;
        view.timeTo = this.timeTo;
        view.recordLimit = this.recordLimit;
        return view;
    }

    public HistoricalDataView() {
        super(LocalizationHelper.getI18n(HistoricalDataView.class).tr("Historical Data"), ResourceManager.getImageDescriptor((String)"icons/object-views/history-view.png"), UUID.randomUUID().toString(), true);
    }

    public String getFullName() {
        return this.fullName;
    }

    protected void createContent(Composite parent) {
        String[] stringArray;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.infoArea = new Composite(parent, 0);
        this.infoArea.setLayoutData((Object)new GridData(4, 4, true, false));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 9;
        this.infoArea.setLayout((Layout)layout);
        this.labelDciId = new Label(this.infoArea, 0);
        this.labelDciId.setText(Long.toString(this.dciId));
        HistoricalDataView.createSeparator((Composite)this.infoArea);
        this.labelDciDescription = new RoundedLabel(this.infoArea);
        HistoricalDataView.createSeparator((Composite)this.infoArea);
        this.labelDciName = new Label(this.infoArea, 0);
        HistoricalDataView.createSeparator((Composite)this.infoArea);
        this.labelDciUnits = new Label(this.infoArea, 0);
        HistoricalDataView.createSeparator((Composite)this.infoArea);
        this.labelTableInfo = new Label(this.infoArea, 0);
        new Label(parent, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.tableName != null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.i18n.tr("Timestamp");
            stringArray = stringArray2;
            stringArray2[1] = this.i18n.tr("Value");
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = this.i18n.tr("Timestamp");
            stringArray3[1] = this.i18n.tr("Value");
            stringArray3[2] = this.i18n.tr("Formatted value");
            stringArray = stringArray3;
            stringArray3[3] = this.i18n.tr("Raw value");
        }
        String[] names = stringArray;
        int[] widths = new int[]{180, 400, 400, 400};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 1024, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new HistoricalDataLabelProvider());
        this.viewer.setComparator((ViewerComparator)new HistoricalDataComparator());
        HistoricalDataFilter filter = new HistoricalDataFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.createActions();
        this.createContextMenu();
        this.refresh();
    }

    private static void createSeparator(Composite parent) {
        GridData gd = new GridData(0x1000000, 4, false, true);
        gd.heightHint = 28;
        new Label(parent, 514).setLayoutData((Object)gd);
    }

    private void createActions() {
        this.actionSelectRange = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+R", (IAction)this.actionSelectRange);
        this.actionDeleteDciEntry = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSelectRange);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSelectRange);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        super.fillLocalMenu(manager);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener((IMenuListener & Serializable)m -> this.fillContextMenu(m));
        this.viewer.getControl().setMenu(manager.createContextMenu(this.viewer.getControl()));
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionSelectRange);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDeleteDciEntry);
    }

    public void refresh() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void selectRange() {
        HistoricalDataSelectionDialog dlg = new HistoricalDataSelectionDialog(this.getWindow().getShell(), this.recordLimit, this.timeFrom, this.timeTo);
        if (dlg.open() == 0) {
            this.recordLimit = dlg.getMaxRecords();
            this.timeFrom = dlg.getTimeFrom();
            this.timeTo = dlg.getTimeTo();
            this.refresh();
        }
    }

    private void deleteValue() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof AbstractObject && ((AbstractObject)context).getObjectId() == this.contextId;
    }

    protected void contextChanged(Object oldContext, Object newContext) {
        if (newContext == null || !(newContext instanceof AbstractObject) || ((AbstractObject)newContext).getObjectId() != this.contextId) {
            return;
        }
        this.refresh();
    }

    public boolean isCloseable() {
        return true;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("contextId", this.contextId);
        memento.set("ownerId", this.ownerId);
        memento.set("dciId", this.dciId);
        if (this.tableName != null) {
            memento.set("tableName", this.tableName);
        }
        if (this.instance != null) {
            memento.set("instance", this.instance);
        }
        if (this.column != null) {
            memento.set("column", this.column);
        }
        if (this.timeFrom != null) {
            memento.set("timeFrom", this.timeFrom.getTime());
        }
        if (this.timeTo != null) {
            memento.set("timeTo", this.timeTo.getTime());
        }
        memento.set("recordLimit", this.recordLimit);
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        this.ownerId = memento.getAsLong("ownerId", 0L);
        this.contextId = memento.getAsLong("contextId", 0L);
        this.dciId = memento.getAsLong("dciId", 0L);
        this.tableName = memento.getAsString("tableName", null);
        this.instance = memento.getAsString("instance", null);
        this.column = memento.getAsString("column", null);
        AbstractObject object = this.session.findObjectById(this.contextId);
        if (object != null) {
            this.nodeName = object.getObjectName();
        }
        String dciName = this.tableName == null ? Long.toString(this.dciId) : this.tableName;
        this.fullName = this.nodeName + ": [" + dciName + "]";
        this.setName(dciName);
        long timestmap = memento.getAsLong("timeFrom", 0L);
        if (timestmap != 0L) {
            this.timeFrom = new Date(timestmap);
        }
        if ((timestmap = memento.getAsLong("timeTo", 0L)) != 0L) {
            this.timeTo = new Date(timestmap);
        }
        this.recordLimit = memento.getAsInteger("recordLimit", this.recordLimit);
        super.restoreState(memento);
    }

    protected Object restoreContext(Memento memento) {
        return this.session.findObjectById(this.contextId);
    }
}

