/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataCollectionObjectStatus;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.ThresholdLabelProvider;
import org.netxms.nxmc.modules.objects.widgets.helpers.BaseObjectLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class LastValuesLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(LastValuesLabelProvider.class);
    private Image[] stateImages = new Image[3];
    private boolean useMultipliers = true;
    private boolean showErrors = true;
    private ThresholdLabelProvider thresholdLabelProvider;
    private BaseObjectLabelProvider objectLabelProvider;
    private NXCSession session;
    private SortableTableViewer viewer;

    public LastValuesLabelProvider(SortableTableViewer viewer) {
        this.viewer = viewer;
        this.stateImages[0] = ResourceManager.getImageDescriptor((String)"icons/dci/active.gif").createImage();
        this.stateImages[1] = ResourceManager.getImageDescriptor((String)"icons/dci/disabled.gif").createImage();
        this.stateImages[2] = ResourceManager.getImageDescriptor((String)"icons/dci/unsupported.gif").createImage();
        this.thresholdLabelProvider = new ThresholdLabelProvider();
        this.objectLabelProvider = new BaseObjectLabelProvider();
        this.session = Registry.getSession();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        switch ((Integer)this.viewer.getTable().getColumn(columnIndex).getData("ID")) {
            case 0: {
                AbstractObject object = this.session.findObjectById(((DciValue)element).getNodeId());
                return object != null ? this.objectLabelProvider.getImage((Object)object) : null;
            }
            case 1: {
                return this.stateImages[((DciValue)element).getStatus().getValue()];
            }
            case 6: {
                if (((DciValue)element).getThresholdDisableEndTime() != 0L) {
                    return StatusDisplayInfo.getStatusImage((ObjectStatus)ObjectStatus.UNMANAGED);
                }
                Threshold threshold = ((DciValue)element).getActiveThreshold();
                return threshold != null ? this.thresholdLabelProvider.getColumnImage((Object)threshold, 1) : StatusDisplayInfo.getStatusImage((Severity)Severity.NORMAL);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DciValue dciValue = (DciValue)element;
        switch ((Integer)this.viewer.getTable().getColumn(columnIndex).getData("ID")) {
            case 9: {
                return dciValue.getComments().replace("\r", "").replace('\n', ' ');
            }
            case 2: {
                return dciValue.getDescription();
            }
            case 7: {
                return this.getEventName(dciValue);
            }
            case 1: {
                return Long.toString(dciValue.getId());
            }
            case 8: {
                return this.getEventMessage(dciValue);
            }
            case 0: {
                return this.session.getObjectNameWithAlias(dciValue.getNodeId());
            }
            case 5: {
                return dciValue.getUserTag();
            }
            case 6: {
                return this.formatThreshold(dciValue);
            }
            case 4: {
                if (dciValue.getTimestamp().getTime() <= 1000L) {
                    return null;
                }
                return DateFormatFactory.getDateTimeFormat().format(dciValue.getTimestamp());
            }
            case 3: {
                if (this.showErrors && dciValue.getErrorCount() > 0) {
                    return this.i18n.tr("<< ERROR >>");
                }
                if (dciValue.getDcObjectType() == 2) {
                    return this.i18n.tr("<< TABLE >>");
                }
                return dciValue.getFormattedValue(this.useMultipliers, DateFormatFactory.getTimeFormatter());
            }
        }
        return null;
    }

    private String formatThreshold(DciValue value) {
        if (value.getThresholdDisableEndTime() != 0L) {
            if (value.getThresholdDisableEndTime() == -1L) {
                return this.i18n.tr("Disabled permanently");
            }
            return this.i18n.tr("Disabled until {0}", (Object)DateFormatFactory.getDateTimeFormat().format(value.getThresholdDisableEndTime() * 1000L));
        }
        Threshold threshold = value.getActiveThreshold();
        if (threshold == null) {
            return this.i18n.tr("OK");
        }
        if (value.getDcObjectType() == 2) {
            return threshold.getValue();
        }
        return this.thresholdLabelProvider.getColumnText((Object)threshold, 0);
    }

    public String getEventName(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        if (threshold == null) {
            return "";
        }
        return this.session.getEventName(threshold.getFireEvent());
    }

    public String getEventMessage(DciValue value) {
        Threshold threshold = value.getActiveThreshold();
        return threshold != null ? threshold.getLastEventMessage() : "";
    }

    public void dispose() {
        for (int i = 0; i < this.stateImages.length; ++i) {
            this.stateImages[i].dispose();
        }
        this.thresholdLabelProvider.dispose();
        this.objectLabelProvider.dispose();
        super.dispose();
    }

    public boolean areMultipliersUsed() {
        return this.useMultipliers;
    }

    public void setUseMultipliers(boolean useMultipliers) {
        this.useMultipliers = useMultipliers;
    }

    public Color getForeground(Object element, int columnIndex) {
        if (((DciValue)element).getStatus() == DataCollectionObjectStatus.DISABLED) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNMANAGED);
        }
        if (this.showErrors && ((DciValue)element).getErrorCount() > 0) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.CRITICAL);
        }
        if (((DciValue)element).isAnomalyDetected()) {
            return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.MAJOR);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public boolean isShowErrors() {
        return this.showErrors;
    }

    public void setShowErrors(boolean showErrors) {
        this.showErrors = showErrors;
    }
}

