/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.constants.DataCollectionObjectStatus;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.datacollection.views.DataComparisonView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalDataView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.datacollection.widgets.BaseTableValueViewer;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.xnap.commons.i18n.I18n;

public class TableValueViewer
extends BaseTableValueViewer {
    private I18n i18n;
    private static long uniqueId = 1L;
    private long objectId = 0L;
    private long dciId = 0L;
    private String objectName = null;
    private String statusMessage = null;
    private Action actionShowHistory;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public TableValueViewer(Composite parent, int style, ObjectView view, String configSubId, boolean saveTableSettings) {
        super(parent, style, view, configSubId, saveTableSettings);
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(TableValueViewer.class);
    }

    protected String buildConfigId(String configSubId) {
        StringBuilder sb = new StringBuilder("TableLastValues.");
        sb.append(this.dciId);
        if (configSubId != null) {
            sb.append('.');
            sb.append(configSubId);
        }
        return sb.toString();
    }

    protected void createActions() {
        super.createActions();
        this.actionShowHistory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLineChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowBarChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowPieChart = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowHistory);
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void setObject(long objectId, long dciId) {
        this.objectId = objectId;
        this.dciId = dciId;
        this.objectName = this.session.getObjectName(objectId);
    }

    private void showHistory() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            String tableName = column.getDisplayName() + ": " + instance.replace("~~~", " / ");
            AbstractObject object = this.session.findObjectById(this.objectId);
            this.view.openView((View)new HistoricalDataView(object, object.getObjectId(), this.dciId, tableName, instance, column.getName()));
        }
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uniqueId++);
        ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            ChartDciConfig config = new ChartDciConfig();
            config.nodeId = this.objectId;
            config.dciId = this.dciId;
            config.dciName = column.getDisplayName() + ": " + instance.replace("~~~", " / ");
            config.type = 2;
            config.instance = instance;
            config.column = column.getName();
            items.add(config);
        }
        AbstractObject object = this.view.getObject();
        this.view.openView((View)new HistoricalGraphView(object, items, null, 0L));
    }

    private void showDataComparisonChart(ChartType chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            ChartDciConfig item = new ChartDciConfig();
            item.nodeId = this.objectId;
            item.dciId = this.dciId;
            item.dciName = this.currentData.getTitle();
            item.name = column.getDisplayName() + ": " + instance.replace("~~~", " / ");
            item.instance = instance;
            item.column = column.getName();
            item.displayFormat = "%s";
            items.add(item);
        }
        this.view.openView((View)new DataComparisonView(this.objectId, items, chartType, this.objectId));
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "[" + this.dciId + "]";
    }

    protected Table readData() throws Exception {
        this.statusMessage = null;
        if (this.objectId == 0L) {
            return null;
        }
        Table table = this.session.getTableLastValues(this.objectId, this.dciId);
        DciValue dciInfo = this.getDciInfo();
        if (dciInfo != null) {
            if (dciInfo.getStatus() == DataCollectionObjectStatus.DISABLED) {
                this.statusMessage = this.i18n.tr("Data collection is disabled");
                return null;
            }
            if (dciInfo.getStatus() == DataCollectionObjectStatus.UNSUPPORTED) {
                this.statusMessage = this.i18n.tr("Metric is not supported");
                return null;
            }
            if (dciInfo.getErrorCount() > 0) {
                this.statusMessage = String.format(this.i18n.tr("Data collection error (%d consecutive failures)"), dciInfo.getErrorCount());
                return null;
            }
            if ((table == null || table.getRowCount() == 0) && dciInfo.isNoValueObject()) {
                this.statusMessage = this.i18n.tr("No data collected yet");
                return null;
            }
        }
        return table;
    }

    private DciValue getDciInfo() throws Exception {
        DciValue[] dciList;
        for (DciValue dci : dciList = this.session.getLastValues(this.objectId)) {
            if (dci.getId() != this.dciId || dci.getDcObjectType() != 2) continue;
            return dci;
        }
        return null;
    }

    protected String getNoDataMessage() {
        return this.statusMessage;
    }

    protected String getReadJobName() {
        return String.format(this.i18n.tr("Loading data for table DCI %d"), this.dciId);
    }

    protected String getReadJobErrorMessage() {
        return String.format(this.i18n.tr("Cannot get data for table DCI %d"), this.dciId);
    }

    public void resetColumns() {
        if (this.currentData == null) {
            return;
        }
        this.currentData.deleteAllRows();
        this.viewer.reset();
    }
}

