/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Event;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.helpers.HistoricalEvent;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class EventDetailsDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(EventDetailsDialog.class);
    private Object event;
    private NXCSession session;

    public EventDetailsDialog(Shell parentShell, Object event) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.event = event;
        this.session = Registry.getSession();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Event Details"));
        newShell.setMinimumSize(500, 400);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("Close"), true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        long id = this.getEventId();
        int code = this.getEventCode();
        Date timeStamp = this.getEventTimestamp();
        long sourceId = this.getEventSourceId();
        long dciId = this.getEventDciId();
        Severity severity = this.getEventSeverity();
        String message = this.getEventMessage();
        String userTag = this.getEventUserTag();
        String[] parameters = this.getEventParameters();
        String eventName = this.session.getEventName(code);
        String sourceName = this.session.getObjectName(sourceId);
        this.createLabel(dialogArea, this.i18n.tr("Event ID:"));
        this.createReadOnlyText(dialogArea, Long.toString(id));
        this.createLabel(dialogArea, this.i18n.tr("Event code:"));
        this.createReadOnlyText(dialogArea, Integer.toString(code));
        this.createLabel(dialogArea, this.i18n.tr("Event name:"));
        this.createReadOnlyText(dialogArea, eventName);
        this.createLabel(dialogArea, this.i18n.tr("Timestamp:"));
        this.createReadOnlyText(dialogArea, DateFormatFactory.getDateTimeFormat().format(timeStamp));
        this.createLabel(dialogArea, this.i18n.tr("Severity:"));
        Composite severityComposite = new Composite(dialogArea, 0);
        GridLayout severityLayout = new GridLayout(2, false);
        severityLayout.marginWidth = 0;
        severityLayout.marginHeight = 0;
        severityComposite.setLayout((Layout)severityLayout);
        severityComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label severityIcon = new Label(severityComposite, 0);
        severityIcon.setImage(StatusDisplayInfo.getStatusImage((Severity)severity));
        Label severityText = new Label(severityComposite, 0);
        severityText.setText(StatusDisplayInfo.getStatusText((Severity)severity));
        severityText.setForeground(StatusDisplayInfo.getStatusColor((Severity)severity));
        this.createLabel(dialogArea, this.i18n.tr("Source:"));
        this.createReadOnlyText(dialogArea, sourceName + " [" + sourceId + "]");
        if (dciId > 0L) {
            this.createLabel(dialogArea, this.i18n.tr("DCI ID:"));
            this.createReadOnlyText(dialogArea, Long.toString(dciId));
        }
        if (userTag != null && !userTag.isEmpty()) {
            this.createLabel(dialogArea, this.i18n.tr("User tag:"));
            this.createReadOnlyText(dialogArea, userTag);
        }
        Label messageLabel = this.createLabel(dialogArea, this.i18n.tr("Message:"));
        GridData gd = (GridData)messageLabel.getLayoutData();
        gd.verticalAlignment = 128;
        Text messageText = new Text(dialogArea, 2634);
        messageText.setText(message);
        gd = new GridData(4, 4, true, false);
        gd.heightHint = 60;
        gd.widthHint = 400;
        messageText.setLayoutData((Object)gd);
        if (parameters != null && parameters.length > 0) {
            String[] parameterNames = this.getEventParameterNames();
            Label parametersLabel = this.createLabel(dialogArea, this.i18n.tr("Parameters:"));
            gd = (GridData)parametersLabel.getLayoutData();
            gd.verticalAlignment = 128;
            Table parametersTable = new Table(dialogArea, 67584);
            parametersTable.setHeaderVisible(true);
            parametersTable.setLinesVisible(true);
            gd = new GridData(4, 4, true, true);
            gd.heightHint = 100;
            parametersTable.setLayoutData((Object)gd);
            TableColumn colIndex = new TableColumn(parametersTable, 16384);
            colIndex.setText(this.i18n.tr("Index"));
            colIndex.setWidth(60);
            TableColumn colName = new TableColumn(parametersTable, 16384);
            colName.setText(this.i18n.tr("Name"));
            colName.setWidth(150);
            TableColumn colValue = new TableColumn(parametersTable, 16384);
            colValue.setText(this.i18n.tr("Value"));
            colValue.setWidth(250);
            for (int i = 0; i < parameters.length; ++i) {
                TableItem item = new TableItem(parametersTable, 0);
                item.setText(0, Integer.toString(i + 1));
                String name = parameterNames != null && i < parameterNames.length ? parameterNames[i] : "";
                item.setText(1, name != null ? name : "");
                item.setText(2, parameters[i] != null ? parameters[i] : "");
            }
        }
        return dialogArea;
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        return label;
    }

    private Text createReadOnlyText(Composite parent, String text) {
        Text textWidget = new Text(parent, 2056);
        textWidget.setText(text != null ? text : "");
        textWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return textWidget;
    }

    private long getEventId() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getId();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getId();
        }
        return 0L;
    }

    private int getEventCode() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getCode();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getCode();
        }
        return 0;
    }

    private Date getEventTimestamp() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getTimeStamp();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getTimeStamp();
        }
        return new Date();
    }

    private long getEventSourceId() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getSourceId();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getSourceId();
        }
        return 0L;
    }

    private long getEventDciId() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getDciId();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getDciId();
        }
        return 0L;
    }

    private Severity getEventSeverity() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getSeverity();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getSeverity();
        }
        return Severity.NORMAL;
    }

    private String getEventMessage() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getMessage();
        }
        if (this.event instanceof HistoricalEvent) {
            return ((HistoricalEvent)this.event).getMessage();
        }
        return "";
    }

    private String getEventUserTag() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getUserTag();
        }
        return null;
    }

    private String[] getEventParameters() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getParameters();
        }
        return null;
    }

    private String[] getEventParameterNames() {
        if (this.event instanceof Event) {
            return ((Event)this.event).getParameterNames();
        }
        return null;
    }
}

