/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.ClientLocalizationHelper;
import org.netxms.client.events.TimeFrame;
import org.netxms.client.events.TimeFrameFormatException;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class TimeFrameEditorDialog
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(TimeFrameEditorDialog.class);
    private TimeFrame timeFrame;
    private DateTime timePickerFrom;
    private DateTime timePickerTo;
    private Button[] daysOfWeekButton;
    private LabeledText daysText;
    private Button[] monthsButton;

    public TimeFrameEditorDialog(Shell parentShell, TimeFrame timeFrame) {
        super(parentShell);
        this.timeFrame = timeFrame;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.timeFrame == null ? this.i18n.tr("Add Time Frame") : this.i18n.tr("Edit Time Frame"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Composite timeSelector = new Composite(dialogArea, 0);
        GridLayout timeSelectorLayout = new GridLayout();
        timeSelectorLayout.numColumns = 3;
        timeSelectorLayout.marginWidth = 0;
        timeSelectorLayout.marginLeft = 0;
        timeSelector.setLayout((Layout)timeSelectorLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 16384;
        timeSelector.setLayoutData((Object)gd);
        this.timePickerFrom = new DateTime(timeSelector, 32896);
        this.timePickerFrom.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.timePickerTo = new DateTime(timeSelector, 32896);
        this.timePickerTo.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Button anyTimeButton = new Button(timeSelector, 8);
        anyTimeButton.setText(this.i18n.tr("An&y time"));
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        anyTimeButton.setLayoutData((Object)gd);
        anyTimeButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(dialogArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite daySelector = new Composite(dialogArea, 0);
        GridLayout dayLayout = new GridLayout();
        dayLayout.numColumns = 7;
        dayLayout.marginWidth = 0;
        dayLayout.marginLeft = 0;
        daySelector.setLayout((Layout)dayLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        daySelector.setLayoutData((Object)gd);
        this.daysOfWeekButton = new Button[7];
        for (int i = 0; i < 7; ++i) {
            this.daysOfWeekButton[i] = new Button(daySelector, 32);
            this.daysOfWeekButton[i].setText(ClientLocalizationHelper.getText((String)TimeFrame.DAYS_OF_THE_WEEK[i]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.daysOfWeekButton[i].setLayoutData((Object)gd);
        }
        Button selectAll = new Button(daySelector, 8);
        selectAll.setText(this.i18n.tr("Select all"));
        gd = new GridData();
        gd.widthHint = 90;
        selectAll.setLayoutData((Object)gd);
        selectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button resetWeekDays = new Button(daySelector, 8);
        resetWeekDays.setText(this.i18n.tr("Clear all"));
        gd = new GridData();
        gd.widthHint = 90;
        resetWeekDays.setLayoutData((Object)gd);
        resetWeekDays.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        new Label(dialogArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.daysText = new LabeledText(dialogArea, 0, 2048);
        this.daysText.setLabel(this.i18n.tr("Days of the month (e.g. 1-5, 8, 11-13, L)"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.daysText.setLayoutData((Object)gd);
        new Label(dialogArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Composite monthSelector = new Composite(dialogArea, 0);
        GridLayout monthLayout = new GridLayout();
        monthLayout.numColumns = 6;
        monthLayout.marginWidth = 0;
        monthLayout.marginLeft = 0;
        monthSelector.setLayout((Layout)monthLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        monthSelector.setLayoutData((Object)gd);
        this.monthsButton = new Button[12];
        for (int i = 0; i < 12; ++i) {
            this.monthsButton[i] = new Button(monthSelector, 32);
            this.monthsButton[i].setText(ClientLocalizationHelper.getText((String)TimeFrame.MONTHS[i]));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.monthsButton[i].setLayoutData((Object)gd);
        }
        Button selectAllMonths = new Button(monthSelector, 8);
        selectAllMonths.setText(this.i18n.tr("Select all"));
        gd = new GridData();
        gd.widthHint = 90;
        selectAllMonths.setLayoutData((Object)gd);
        selectAllMonths.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button resetMonths = new Button(monthSelector, 8);
        resetMonths.setText(this.i18n.tr("Clear all"));
        gd = new GridData();
        gd.widthHint = 90;
        resetMonths.setLayoutData((Object)gd);
        resetMonths.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (this.timeFrame != null) {
            int i;
            this.timePickerFrom.setMinutes(this.timeFrame.getStartMinute());
            this.timePickerFrom.setHours(this.timeFrame.getStartHour());
            this.timePickerTo.setMinutes(this.timeFrame.getEndMinute());
            this.timePickerTo.setHours(this.timeFrame.getEndHour());
            for (i = 0; i < 7; ++i) {
                this.daysOfWeekButton[i].setSelection(this.timeFrame.getDaysOfWeek()[i]);
            }
            this.daysText.setText(this.timeFrame.getDaysOfMonth());
            for (i = 0; i < 12; ++i) {
                this.monthsButton[i].setSelection(this.timeFrame.getMonths()[i]);
            }
        } else {
            this.timePickerFrom.setHours(0);
            this.timePickerFrom.setMinutes(0);
            this.timePickerTo.setHours(23);
            this.timePickerTo.setMinutes(59);
        }
        return dialogArea;
    }

    protected void okPressed() {
        if (this.timeFrame == null) {
            this.timeFrame = new TimeFrame();
        }
        boolean[] daysOfWeek = new boolean[7];
        for (int i = 0; i < 7; ++i) {
            daysOfWeek[i] = this.daysOfWeekButton[i].getSelection();
        }
        String days = this.daysText.getText();
        if (days.isBlank()) {
            days = "1-31";
        }
        boolean[] months = new boolean[12];
        for (int i = 0; i < 12; ++i) {
            months[i] = this.monthsButton[i].getSelection();
        }
        try {
            this.timeFrame.update(this.timePickerFrom.getHours(), this.timePickerFrom.getMinutes(), this.timePickerTo.getHours(), this.timePickerTo.getMinutes(), daysOfWeek, days, months);
        }
        catch (TimeFrameFormatException e) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
            return;
        }
        super.okPressed();
    }

    public TimeFrame getTimeFrame() {
        return this.timeFrame;
    }
}

