/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.resources.StatusDisplayInfo;

public class RuleSeverityFilter
extends RuleBasePropertyPage {
    private static final int[] severityFlag = new int[]{256, 512, 1024, 2048, 4096};
    private Button[] checkButton = new Button[5];

    public RuleSeverityFilter(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleSeverityFilter.class).tr("Severity Filter"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        RowLayout layout = new RowLayout();
        layout.type = 512;
        layout.spacing = 4;
        dialogArea.setLayout((Layout)layout);
        for (int i = 0; i < this.checkButton.length; ++i) {
            this.checkButton[i] = new Button(dialogArea, 32);
            this.checkButton[i].setText(StatusDisplayInfo.getStatusText((int)i));
            this.checkButton[i].setSelection((this.rule.getFlags() & severityFlag[i]) != 0);
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        for (int i = 0; i < this.checkButton.length; ++i) {
            if (this.checkButton[i].getSelection()) {
                this.rule.setFlags(this.rule.getFlags() | severityFlag[i]);
                continue;
            }
            this.rule.setFlags(this.rule.getFlags() & ~severityFlag[i]);
        }
        this.editor.setModified(true);
        return true;
    }
}

