/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.propertypages;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.events.TimeFrame;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.TimeFrameEditorDialog;
import org.netxms.nxmc.modules.events.propertypages.RuleBasePropertyPage;
import org.netxms.nxmc.modules.events.propertypages.helpers.TimeFrameLabelProvider;
import org.netxms.nxmc.modules.events.widgets.RuleEditor;
import org.netxms.nxmc.tools.ElementLabelComparator;
import org.xnap.commons.i18n.I18n;

public class RuleTimeFilter
extends RuleBasePropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(RuleTimeFilter.class);
    private final String[] EMPTY_LIST_PLACEHOLDER = new String[]{this.i18n.tr("Any time")};
    private List<TimeFrame> frames = new ArrayList();
    private TableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private Button checkInverted;

    public RuleTimeFilter(RuleEditor editor) {
        super(editor, LocalizationHelper.getI18n(RuleTimeFilter.class).tr("Time Filter"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        this.checkInverted.setText(this.i18n.tr("Inverse rule (match time that is NOT within time frames listed below)"));
        this.checkInverted.setSelection(this.rule.isTimeFramesInverted());
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TimeFrameLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.viewer.getLabelProvider()));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.frames.addAll(this.rule.getTimeFrames());
        this.setViewerInput();
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 0;
        gd.horizontalSpan = 1;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(event -> this.editFrame());
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(this.i18n.tr("&Add..."));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void addFrame() {
        TimeFrameEditorDialog dlg = new TimeFrameEditorDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            this.frames.add(dlg.getTimeFrame());
            this.setViewerInput();
        }
    }

    private void editFrame() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && !(selection.getFirstElement() instanceof String)) {
            TimeFrame element = (TimeFrame)selection.getFirstElement();
            TimeFrameEditorDialog dlg = new TimeFrameEditorDialog(this.getShell(), element);
            if (dlg.open() == 0) {
                this.viewer.update((Object)element, null);
            }
        }
    }

    private void deleteFrame() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                TimeFrame e = (TimeFrame)it.next();
                this.frames.remove(e);
            }
            this.setViewerInput();
        }
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = this.rule.getFlags();
        flags = this.checkInverted.getSelection() && !this.frames.isEmpty() ? (flags |= 0x8000) : (flags &= 0xFFFF7FFF);
        this.rule.setFlags(flags);
        this.rule.setTimeFrames(this.frames);
        this.editor.setModified(true);
        return true;
    }

    private void setViewerInput() {
        if (this.frames.isEmpty()) {
            this.viewer.setInput((Object)this.EMPTY_LIST_PLACEHOLDER);
        } else {
            this.viewer.setInput((Object)this.frames);
        }
    }
}

