/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import java.io.Serializable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.Event;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.AbstractTraceWidget;
import org.netxms.nxmc.base.widgets.helpers.AbstractTraceViewFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.EventDetailsDialog;
import org.netxms.nxmc.modules.events.widgets.EventTraceWidget;
import org.netxms.nxmc.modules.events.widgets.helpers.EventLabelProvider;
import org.netxms.nxmc.modules.events.widgets.helpers.EventMonitorFilter;
import org.netxms.nxmc.modules.events.widgets.helpers.HistoricalEvent;
import org.netxms.nxmc.modules.logviewer.views.AdHocEventLogView;
import org.xnap.commons.i18n.I18n;

public class EventTraceWidget
extends AbstractTraceWidget
implements SessionListener {
    public static final int COLUMN_TIMESTAMP = 0;
    public static final int COLUMN_SOURCE = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_EVENT = 3;
    public static final int COLUMN_MESSAGE = 4;
    private I18n i18n;
    private NXCSession session;
    private Action actionShowColor;
    private Action actionShowIcons;
    private Action actionShowDetails;
    private EventLabelProvider labelProvider;
    private EventInterceptor eventInterceptor;

    public EventTraceWidget(Composite parent, int style, View view) {
        super(parent, style, view);
        System.out.println("Creating EventTraceWidget");
        this.session = Registry.getSession();
        this.session.addListener((SessionListener)this);
        this.addDisposeListener((DisposeListener & Serializable)e -> this.session.removeListener((SessionListener)this));
    }

    protected void setupLocalization() {
        this.i18n = LocalizationHelper.getI18n(EventTraceWidget.class);
    }

    protected void setupViewer(TableViewer viewer) {
        this.labelProvider = new EventLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        PreferenceStore settings = PreferenceStore.getInstance();
        this.labelProvider.setShowColor(settings.getAsBoolean("EventMonitor.showColor", true));
        this.labelProvider.setShowIcons(settings.getAsBoolean("EventMonitor.showIcons", false));
        this.addColumn(this.i18n.tr("Timestamp"), 150);
        this.addColumn(this.i18n.tr("Source"), 200);
        this.addColumn(this.i18n.tr("Severity"), 90);
        this.addColumn(this.i18n.tr("Event"), 200);
        this.addColumn(this.i18n.tr("Message"), 600);
        viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected AbstractTraceViewFilter createFilter() {
        return new EventMonitorFilter();
    }

    protected void saveConfig() {
        super.saveConfig();
        PreferenceStore ps = PreferenceStore.getInstance();
        ps.set("EventMonitor.showColor", this.labelProvider.isShowColor());
        ps.set("EventMonitor.showIcons", this.labelProvider.isShowIcons());
    }

    protected String getConfigPrefix() {
        return "EventMonitor";
    }

    protected void createActions() {
        super.createActions();
        this.actionShowColor = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowColor.setChecked(this.labelProvider.isShowColor());
        this.actionShowIcons = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowIcons.setChecked(this.labelProvider.isShowIcons());
        this.actionShowDetails = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object element;
        super.fillContextMenu(manager);
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && ((element = selection.getFirstElement()) instanceof Event || element instanceof HistoricalEvent)) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowDetails);
            MenuManager openEventLogMenu = new MenuManager(this.i18n.tr("Open event log"));
            this.addOpenEventLogActions((IMenuManager)openEventLogMenu, element);
            manager.add((IContributionItem)openEventLogMenu);
        }
    }

    private void addOpenEventLogActions(IMenuManager manager, Object event) {
        int code;
        long sourceId;
        if (event instanceof Event) {
            sourceId = ((Event)event).getSourceId();
            code = ((Event)event).getCode();
        } else {
            sourceId = ((HistoricalEvent)event).getSourceId();
            code = ((HistoricalEvent)event).getCode();
        }
        String sourceName = this.session.getObjectName(sourceId);
        String eventName = this.session.getEventName(code);
        manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
        manager.add((IAction)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void openEventLogFiltered(Long sourceId, Integer eventCode, String titleSuffix) {
        AdHocEventLogView logView = new AdHocEventLogView(sourceId, eventCode, titleSuffix);
        this.view.openView((View)logView);
    }

    private void showEventDetails() {
        Object element;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && ((element = selection.getFirstElement()) instanceof Event || element instanceof HistoricalEvent)) {
            EventDetailsDialog dialog = new EventDetailsDialog(this.getShell(), element);
            dialog.open();
        }
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 2) {
            this.runInUIThread(() -> {
                if (this.eventInterceptor == null || !this.eventInterceptor.interceptEvent(n.getObject())) {
                    this.addElement(n.getObject());
                }
            });
        }
    }

    public void setEventInterceptor(EventInterceptor interceptor) {
        this.eventInterceptor = interceptor;
    }

    public void addEvent(Object event) {
        this.addElement(event);
    }

    public void setEventCodeFilter(int[] codes) {
        ((EventMonitorFilter)this.filter).setEventCodes(codes);
        this.refresh();
    }

    public Action getActionShowColor() {
        return this.actionShowColor;
    }

    public Action getActionShowIcons() {
        return this.actionShowIcons;
    }
}

