/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets;

import java.util.Arrays;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.events.EventTemplate;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.dialogs.MultiEventSelectionDialog;
import org.xnap.commons.i18n.I18n;

public class MultiEventSelector
extends AbstractSelector {
    private final I18n i18n = LocalizationHelper.getI18n(MultiEventSelector.class);
    private int[] eventCodes = new int[0];

    public MultiEventSelector(Composite parent, int style) {
        this(parent, style, new SelectorConfigurator());
    }

    public MultiEventSelector(Composite parent, int style, SelectorConfigurator configurator) {
        super(parent, style, configurator.setSelectionButtonToolTip(LocalizationHelper.getI18n(MultiEventSelector.class).tr("Select events")));
        this.setText(this.i18n.tr("<any>"));
    }

    protected void selectionButtonHandler() {
        MultiEventSelectionDialog dlg = new MultiEventSelectionDialog(this.getShell(), this.eventCodes);
        if (dlg.open() == 0) {
            EventTemplate[] events = dlg.getSelectedEvents();
            int[] prevCodes = this.eventCodes;
            if (events.length > 0) {
                this.eventCodes = new int[events.length];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < events.length; ++i) {
                    this.eventCodes[i] = events[i].getCode();
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append(events[i].getName());
                }
                if (events.length <= 3) {
                    this.setText(sb.toString());
                } else {
                    this.setText(String.format(this.i18n.tr("%d events selected"), events.length));
                }
                this.getTextControl().setToolTipText(sb.toString());
            } else {
                this.eventCodes = new int[0];
                this.setText(this.i18n.tr("<any>"));
                this.getTextControl().setToolTipText(null);
            }
            if (!Arrays.equals(prevCodes, this.eventCodes)) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.eventCodes.length == 0) {
            return;
        }
        this.eventCodes = new int[0];
        this.setText(this.i18n.tr("<any>"));
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public int[] getEventCodes() {
        return this.eventCodes;
    }

    public void setEventCodes(int[] codes) {
        if (codes == null || codes.length == 0) {
            this.eventCodes = new int[0];
            this.setText(this.i18n.tr("Any"));
            this.getTextControl().setToolTipText(null);
            return;
        }
        this.eventCodes = (int[])codes.clone();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < codes.length; ++i) {
            EventTemplate evt = Registry.getSession().findEventTemplateByCode(codes[i]);
            if (i > 0) {
                sb.append(", ");
            }
            if (evt != null) {
                sb.append(evt.getName());
                continue;
            }
            sb.append("[").append(codes[i]).append("]");
        }
        if (codes.length <= 3) {
            this.setText(sb.toString());
        } else {
            this.setText(String.format(this.i18n.tr("%d events selected"), codes.length));
        }
        this.getTextControl().setToolTipText(sb.toString());
    }
}

