/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.events.widgets.helpers;

import java.util.Date;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Event;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.events.widgets.helpers.HistoricalEvent;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.xnap.commons.i18n.I18n;

public class EventLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private final I18n i18n = LocalizationHelper.getI18n(EventLabelProvider.class);
    private NXCSession session = Registry.getSession();
    private boolean showColor = true;
    private boolean showIcons = false;

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        Severity severity;
        if (!this.showColor) {
            return null;
        }
        if (element instanceof Event) {
            severity = ((Event)element).getSeverity();
        } else if (element instanceof HistoricalEvent) {
            severity = ((HistoricalEvent)element).getSeverity();
        } else {
            return null;
        }
        return StatusDisplayInfo.getStatusBackgroundColor((Severity)severity);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.showIcons && columnIndex == 0) {
            Severity severity;
            if (element instanceof Event) {
                severity = ((Event)element).getSeverity();
            } else if (element instanceof HistoricalEvent) {
                severity = ((HistoricalEvent)element).getSeverity();
            } else {
                return null;
            }
            return StatusDisplayInfo.getStatusImage((Severity)severity);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String message;
        int code;
        Severity severity;
        Date timeStamp;
        long sourceId;
        if (element instanceof Event) {
            event = (Event)element;
            sourceId = event.getSourceId();
            timeStamp = event.getTimeStamp();
            severity = event.getSeverity();
            code = event.getCode();
            message = event.getMessage();
        } else if (element instanceof HistoricalEvent) {
            event = (HistoricalEvent)element;
            sourceId = event.getSourceId();
            timeStamp = event.getTimeStamp();
            severity = event.getSeverity();
            code = event.getCode();
            message = event.getMessage();
        } else {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return DateFormatFactory.getDateTimeFormat().format(timeStamp);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(sourceId);
                return object != null ? object.getObjectName() : this.i18n.tr("Unknown");
            }
            case 2: {
                return StatusDisplayInfo.getStatusText((Severity)severity);
            }
            case 3: {
                return this.session.getEventName(code);
            }
            case 4: {
                return message;
            }
        }
        return null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }
}

