/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.server.RemoteFile;
import org.netxms.nxmc.resources.ResourceManager;

public class BaseFileLabelProvider
extends LabelProvider {
    private Map<String, Image> images = new HashMap();

    public BaseFileLabelProvider() {
        this.images.put("folder", ResourceManager.getImageDescriptor((String)"icons/folder.png").createImage());
        this.images.put("unknown", ResourceManager.getImageDescriptor((String)"icons/file-types/unknown.png").createImage());
        this.images.put("exe", ResourceManager.getImageDescriptor((String)"icons/file-types/exec.png").createImage());
        this.images.put("pdf", ResourceManager.getImageDescriptor((String)"icons/file-types/pdf.png").createImage());
        this.images.put("xls", ResourceManager.getImageDescriptor((String)"icons/file-types/xls.png").createImage());
        this.images.put("ppt", ResourceManager.getImageDescriptor((String)"icons/file-types/powerpoint.png").createImage());
        this.images.put("html", ResourceManager.getImageDescriptor((String)"icons/file-types/html.png").createImage());
        this.images.put("txt", ResourceManager.getImageDescriptor((String)"icons/file-types/text.png").createImage());
        this.images.put("avi", ResourceManager.getImageDescriptor((String)"icons/file-types/avi.png").createImage());
        this.images.put("mp4", ResourceManager.getImageDescriptor((String)"icons/file-types/mp4.png").createImage());
        this.images.put("ac3", ResourceManager.getImageDescriptor((String)"icons/file-types/audio.png").createImage());
        this.images.put("tar", ResourceManager.getImageDescriptor((String)"icons/file-types/archive.png").createImage());
    }

    public void dispose() {
        for (Image img : this.images.values()) {
            img.dispose();
        }
        this.images.clear();
        super.dispose();
    }

    public Image getImage(Object element) {
        if (((RemoteFile)element).isPlaceholder()) {
            return null;
        }
        if (((RemoteFile)element).isDirectory()) {
            return (Image)this.images.get("folder");
        }
        String[] parts = ((RemoteFile)element).getName().split("\\.");
        if (parts.length < 2) {
            return (Image)this.images.get("unknown");
        }
        String ext = parts[parts.length - 1];
        if (ext.equalsIgnoreCase("exe")) {
            return (Image)this.images.get("exe");
        }
        if (ext.equalsIgnoreCase("pdf")) {
            return (Image)this.images.get("pdf");
        }
        if (ext.equalsIgnoreCase("xls") || ext.equalsIgnoreCase("xlsx")) {
            return (Image)this.images.get("xls");
        }
        if (ext.equalsIgnoreCase("ppt") || ext.equalsIgnoreCase("pptx")) {
            return (Image)this.images.get("ppt");
        }
        if (ext.equalsIgnoreCase("html") || ext.equalsIgnoreCase("htm")) {
            return (Image)this.images.get("html");
        }
        if (ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("log") || ext.equalsIgnoreCase("jrn")) {
            return (Image)this.images.get("txt");
        }
        if (ext.equalsIgnoreCase("avi") || ext.equalsIgnoreCase("mkv") || ext.equalsIgnoreCase("mov") || ext.equalsIgnoreCase("wma")) {
            return (Image)this.images.get("avi");
        }
        if (ext.equalsIgnoreCase("mp4")) {
            return (Image)this.images.get("mp4");
        }
        if (ext.equalsIgnoreCase("ac3") || ext.equalsIgnoreCase("mp3") || ext.equalsIgnoreCase("wav")) {
            return (Image)this.images.get("ac3");
        }
        if (ext.equalsIgnoreCase("tar") || ext.equalsIgnoreCase("gz") || ext.equalsIgnoreCase("tgz") || ext.equalsIgnoreCase("zip") || ext.equalsIgnoreCase("rar") || ext.equalsIgnoreCase("7z") || ext.equalsIgnoreCase("bz2") || ext.equalsIgnoreCase("lzma")) {
            return (Image)this.images.get("tar");
        }
        return (Image)this.images.get("unknown");
    }

    public String getText(Object element) {
        return ((RemoteFile)element).getName();
    }

    protected static String getSizeString(long size) {
        if (size >= 0xA0000000000L) {
            return String.format("%.1f TB", (double)size / 1.099511627776E12);
        }
        if (size >= 0x280000000L) {
            return String.format("%.1f GB", (double)size / 1.073741824E9);
        }
        if (size >= 0xA00000L) {
            return String.format("%.1f MB", (double)size / 1048576.0);
        }
        if (size >= 10240L) {
            return String.format("%.1f KB", (double)size / 1024.0);
        }
        return Long.toString(size);
    }
}

