/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.netxms.client.NXCSession;
import org.netxms.client.events.IncidentSummary;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;

public class IncidentListFilter
extends ViewerFilter
implements AbstractViewerFilter {
    private NXCSession session = Registry.getSession();
    private String filterString = null;
    private int stateFilter = 31;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        AbstractUserObject user;
        IncidentSummary incident = (IncidentSummary)element;
        if ((this.stateFilter & 1 << incident.getState().getValue()) == 0) {
            return false;
        }
        if (this.filterString == null || this.filterString.isEmpty()) {
            return true;
        }
        if (incident.getTitle().toLowerCase().contains(this.filterString)) {
            return true;
        }
        AbstractObject object = this.session.findObjectById(incident.getSourceObjectId());
        if (object != null && object.getObjectName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        if (incident.getAssignedUserId() != 0 && (user = this.session.findUserDBObjectById(incident.getAssignedUserId(), null)) != null && user.getName().toLowerCase().contains(this.filterString)) {
            return true;
        }
        return Long.toString(incident.getId()).contains(this.filterString);
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString != null ? filterString.toLowerCase() : null;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public int getStateFilter() {
        return this.stateFilter;
    }
}

