/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.incidents.widgets.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.IncidentState;
import org.netxms.client.events.IncidentSummary;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.ViewerElementUpdater;
import org.xnap.commons.i18n.I18n;

public class IncidentListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private final I18n i18n = LocalizationHelper.getI18n(IncidentListLabelProvider.class);
    private TableViewer viewer;
    private NXCSession session;
    private Image[] stateImages;
    private String[] stateNames;

    public IncidentListLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
        this.session = Registry.getSession();
        this.stateImages = new Image[5];
        this.stateImages[IncidentState.OPEN.getValue()] = ResourceManager.getImage((String)"icons/incidents/incident-open.png");
        this.stateImages[IncidentState.IN_PROGRESS.getValue()] = ResourceManager.getImage((String)"icons/incidents/incident-in-progress.png");
        this.stateImages[IncidentState.BLOCKED.getValue()] = ResourceManager.getImage((String)"icons/incidents/incident-blocked.png");
        this.stateImages[IncidentState.RESOLVED.getValue()] = ResourceManager.getImage((String)"icons/incidents/incident-resolved.png");
        this.stateImages[IncidentState.CLOSED.getValue()] = ResourceManager.getImage((String)"icons/incidents/incident-closed.png");
        this.stateNames = new String[5];
        this.stateNames[IncidentState.OPEN.getValue()] = this.i18n.tr("Open");
        this.stateNames[IncidentState.IN_PROGRESS.getValue()] = this.i18n.tr("In Progress");
        this.stateNames[IncidentState.BLOCKED.getValue()] = this.i18n.tr("Blocked");
        this.stateNames[IncidentState.RESOLVED.getValue()] = this.i18n.tr("Resolved");
        this.stateNames[IncidentState.CLOSED.getValue()] = this.i18n.tr("Closed");
    }

    public void dispose() {
        for (int i = 0; i < this.stateImages.length; ++i) {
            if (this.stateImages[i] == null) continue;
            this.stateImages[i].dispose();
        }
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            IncidentState state = ((IncidentSummary)element).getState();
            return this.stateImages[state.getValue()];
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IncidentSummary incident = (IncidentSummary)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(incident.getId());
            }
            case 1: {
                return this.stateNames[incident.getState().getValue()];
            }
            case 2: {
                return incident.getTitle();
            }
            case 3: {
                return this.session.getObjectName(incident.getSourceObjectId());
            }
            case 4: {
                if (incident.getAssignedUserId() == 0) {
                    return "";
                }
                AbstractUserObject user = this.session.findUserDBObjectById(incident.getAssignedUserId(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + Integer.toString(incident.getAssignedUserId()) + "]";
            }
            case 5: {
                return DateFormatFactory.getDateTimeFormat().format(incident.getCreationTime());
            }
            case 6: {
                return DateFormatFactory.getDateTimeFormat().format(incident.getLastChangeTime());
            }
            case 7: {
                return Integer.toString(incident.getAlarmCount());
            }
        }
        return "";
    }
}

