/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.services.LogDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public final class LogDescriptorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(LogDescriptorRegistry.class);
    private final I18n i18n = LocalizationHelper.getI18n(LogDescriptorRegistry.class);
    private List<LogDescriptor> descriptors = new ArrayList();

    public static void attachSession(Display display, NXCSession session) {
        LogDescriptorRegistry instance = new LogDescriptorRegistry(session);
        Registry.setSingleton((Display)display, LogDescriptorRegistry.class, (Object)instance);
    }

    private LogDescriptorRegistry(NXCSession session) {
        this.descriptors.add(new /* Unavailable Anonymous Inner Class!! */);
        this.descriptors.add(new LogDescriptor("AssetChangeLog", this.i18n.tr("Asset Changes"), this.i18n.tr("Asset changes"), "linked_object_id"));
        this.descriptors.add(new /* Unavailable Anonymous Inner Class!! */);
        this.descriptors.add(new /* Unavailable Anonymous Inner Class!! */);
        this.descriptors.add(new LogDescriptor("MaintenanceJournal", this.i18n.tr("Maintenance Journal"), this.i18n.tr("Maintenance journal"), "object_id"));
        this.descriptors.add(new LogDescriptor("NotificationLog", this.i18n.tr("Notifications"), null, null));
        this.descriptors.add(new LogDescriptor("ServerActionExecutionLog", this.i18n.tr("Server Action Executions"), null, null));
        this.descriptors.add(new LogDescriptor("SnmpTrapLog", this.i18n.tr("SNMP Traps"), this.i18n.tr("SNMP traps"), "object_id"));
        this.descriptors.add(new LogDescriptor("syslog", this.i18n.tr("Syslog"), null, "source_object_id"));
        this.descriptors.add(new /* Unavailable Anonymous Inner Class!! */);
        ServiceLoader<LogDescriptor> loader = ServiceLoader.load(LogDescriptor.class, this.getClass().getClassLoader());
        for (LogDescriptor d : loader) {
            if (d.isValidForSession(session)) {
                this.descriptors.add(d);
                logger.debug("Log descriptor " + d.getLogName() + " registered");
                continue;
            }
            logger.debug("Log descriptor " + d.getLogName() + " is not valid for current session");
        }
        this.descriptors.sort((l1, l2) -> l1.getViewTitle().compareToIgnoreCase(l2.getViewTitle()));
    }

    public List<LogDescriptor> getDescriptors() {
        return this.descriptors;
    }

    public LogDescriptor get(String logName) {
        for (LogDescriptor d : this.descriptors) {
            if (!d.getLogName().equals(logName)) continue;
            return d;
        }
        return null;
    }
}

