/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.views;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.log.LogFilter;
import org.netxms.client.log.OrderingColumn;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.base.views.ViewWithContext;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.LogDescriptorRegistry;
import org.netxms.nxmc.modules.logviewer.LogRecordDetailsViewer;
import org.netxms.nxmc.modules.logviewer.LogRecordDetailsViewerRegistry;
import org.netxms.nxmc.modules.logviewer.views.helpers.LogLabelProvider;
import org.netxms.nxmc.modules.logviewer.widgets.FilterBuilder;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.SharedIcons;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

public class LogViewer
extends ViewWithContext {
    private static final int PAGE_SIZE = 400;
    private final I18n i18n = LocalizationHelper.getI18n(LogViewer.class);
    private static final Logger logger = LoggerFactory.getLogger(LogViewer.class);
    protected NXCSession session = Registry.getSession();
    protected TableViewer viewer;
    private FilterBuilder filterBuilder;
    private String logName;
    private Log logHandle;
    private LogFilter delayedQueryFilter = null;
    private LogRecordDetailsViewer recordDetailsViewer;
    private org.netxms.client.Table resultSet;
    private boolean noData = false;
    private Action actionExecute;
    private Action actionClearFilter;
    private Action actionShowFilter;
    private Action actionGetMoreData;
    private Action actionCopyToClipboard;
    private Action actionShowSql;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionShowDetails;

    protected LogViewer() {
        super(null, null, null, false);
    }

    public View cloneView() {
        LogViewer view = (LogViewer)super.cloneView();
        view.logName = this.logName;
        view.recordDetailsViewer = this.recordDetailsViewer;
        return view;
    }

    public LogViewer(String viewName, String logName, String additionalId) {
        super(viewName, ResourceManager.getImageDescriptor((String)("icons/log-viewer/" + logName + ".png")), "LogViewer." + logName + additionalId, false);
        this.logName = logName;
        this.recordDetailsViewer = LogRecordDetailsViewerRegistry.get((String)logName);
    }

    public void createContent(Composite parent) {
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        this.filterBuilder = new FilterBuilder(parent, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        this.filterBuilder.setLayoutData((Object)gd);
        this.viewer = new TableViewer(parent, 65538);
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterBuilder);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        table.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterBuilder.setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
        this.enableRefresh(false);
    }

    protected void postClone(View view) {
        LogViewer origin = (LogViewer)view;
        this.delayedQueryFilter = origin.filterBuilder.createFilter();
        this.openServerLog(true);
        super.postClone(view);
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.openServerLog(false);
    }

    protected void openServerLog(boolean onClone) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected int estimateColumnWidth(LogColumn lc) {
        switch (lc.getType()) {
            case 6: {
                return 80;
            }
            case 5: {
                return 120;
            }
            case 1: {
                return 100;
            }
            case 13: {
                return 100;
            }
            case 2: {
                return 150;
            }
            case 0: {
                return 250;
            }
        }
        return 100;
    }

    protected void setupLogViewer(boolean onClone) {
        Table table = this.viewer.getTable();
        Collection columns = this.logHandle.getColumns();
        LogFilter filter = this.delayedQueryFilter != null ? this.delayedQueryFilter : new LogFilter();
        LogColumn orderingColumn = null;
        for (LogColumn lc : columns) {
            TableColumn column = new TableColumn(table, 16384);
            column.setText(lc.getDescription());
            column.setData((Object)lc);
            column.setWidth(this.estimateColumnWidth(lc));
            if (onClone) continue;
            if (lc.getType() == 6 && (lc.getFlags() & 4) != 0) {
                orderingColumn = lc;
                continue;
            }
            if (orderingColumn != null || lc.getType() != 5) continue;
            orderingColumn = lc;
        }
        WidgetHelper.restoreColumnSettings((Table)table, (String)("LogViewer." + this.logHandle.getName()));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(this.logHandle));
        this.filterBuilder.setLogHandle(this.logHandle);
        if (onClone) {
            this.filterBuilder.setFilter(this.delayedQueryFilter);
        } else {
            if (orderingColumn != null) {
                ArrayList<OrderingColumn> orderingColumns = new ArrayList<OrderingColumn>(1);
                orderingColumns.add(new OrderingColumn(orderingColumn.getName(), orderingColumn.getDescription(), true));
                filter.setOrderingColumns(orderingColumns);
            }
            this.filterBuilder.setFilter(filter);
        }
    }

    protected ITableLabelProvider createLabelProvider(Log logHandle) {
        return new LogLabelProvider(logHandle, this.viewer);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionGetMoreData);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionShowSql);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClearFilter);
        manager.add((IAction)this.actionShowFilter);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionGetMoreData);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionShowSql);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IAction)this.actionClearFilter);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        if (this.recordDetailsViewer != null) {
            mgr.add((IAction)this.actionShowDetails);
            mgr.add((IContributionItem)new Separator());
        }
        mgr.add((IAction)this.actionCopyToClipboard);
        mgr.add((IAction)this.actionExportToCsv);
    }

    protected void createActions() {
        this.actionExecute = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("F9", (IAction)this.actionExecute);
        this.actionClearFilter = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+E", (IAction)this.actionClearFilter);
        this.actionGetMoreData = new /* Unavailable Anonymous Inner Class!! */;
        this.actionGetMoreData.setEnabled(false);
        this.addKeyBinding("M2+F9", (IAction)this.actionGetMoreData);
        this.actionShowFilter = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(true);
        this.addKeyBinding("M1+F2", (IAction)this.actionShowFilter);
        this.actionCopyToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+C", (IAction)this.actionCopyToClipboard);
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
        this.actionShowSql = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowDetails = new /* Unavailable Anonymous Inner Class!! */;
    }

    public void queryWithFilter(LogFilter filter) {
        if (this.logHandle != null) {
            this.filterBuilder.setFilter(filter);
            this.doQuery();
        } else {
            this.delayedQueryFilter = filter;
        }
    }

    private void doQuery() {
        this.onQueryStart();
        LogFilter filter = this.filterBuilder.createFilter();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void getMoreData() {
        if (this.noData) {
            return;
        }
        this.onQueryStart();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void refresh() {
        if (this.resultSet == null) {
            return;
        }
        this.onQueryStart();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void onQueryStart() {
        this.actionExecute.setEnabled(false);
        this.actionGetMoreData.setEnabled(false);
        this.enableRefresh(false);
    }

    private void onQueryComplete() {
        this.actionExecute.setEnabled(true);
        this.actionGetMoreData.setEnabled(!this.noData);
        this.enableRefresh(true);
    }

    private void showRecordDetails() {
        if (this.recordDetailsViewer == null) {
            return;
        }
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        TableRow record = (TableRow)selection.getFirstElement();
        long recordId = record.getValueAsLong(this.logHandle.getRecordIdColumnIndex());
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void setFocus() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().setFocus();
        }
    }

    protected void showFilter(boolean show) {
        this.filterBuilder.setVisible(show);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = show ? new FormAttachment((Control)this.filterBuilder) : new FormAttachment(0, 0);
        this.viewer.getTable().getParent().layout();
        if (show) {
            this.filterBuilder.setFocus();
        }
    }

    private void copySelectionToClipboard() {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            StringBuilder sb = new StringBuilder();
            String newLine = WidgetHelper.getNewLineCharacters();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(0));
                for (int j = 1; j < this.viewer.getTable().getColumnCount(); ++j) {
                    sb.append('\t');
                    sb.append(selection[i].getText(j));
                }
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    private void showQuerySql() {
        LogFilter filter = this.filterBuilder.createFilter();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    protected TableViewer getViewer() {
        return this.viewer;
    }

    protected org.netxms.client.Table getResultSet() {
        return this.resultSet;
    }

    protected int getColumnIndex(String columnName) {
        if (this.resultSet == null) {
            return -1;
        }
        return this.resultSet.getColumnIndex(columnName);
    }

    protected void contextChanged(Object oldContext, Object newContext) {
    }

    public boolean isValidForContext(Object context) {
        return true;
    }

    public String getFullName() {
        return this.getName();
    }

    public Object restoreContext(Memento memento) {
        return null;
    }

    public String getLogName() {
        return this.logName;
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("logName", this.logName);
        LogFilter filter = this.filterBuilder.createFilter();
        try {
            memento.set("filter", XMLTools.serialize((Object)filter));
        }
        catch (Exception e) {
            logger.error("Failed to serialize filter", (Throwable)e);
            memento.set("filter", "");
        }
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.logName = memento.getAsString("logName");
        this.recordDetailsViewer = LogRecordDetailsViewerRegistry.get((String)this.logName);
        this.setName(((LogDescriptorRegistry)Registry.getSingleton(LogDescriptorRegistry.class)).get(this.getLogName()).getViewTitle());
        this.setImage(ResourceManager.getImageDescriptor((String)("icons/log-viewer/" + this.logName + ".png")));
        try {
            this.delayedQueryFilter = (LogFilter)XMLTools.createFromXml(LogFilter.class, (String)memento.getAsString("filter"));
        }
        catch (Exception e) {
            logger.error("Failed to load filter", (Throwable)e);
            throw new ViewNotRestoredException(this.i18n.tr("Failed to load filter"), (Throwable)e);
        }
    }
}

