/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.logviewer.widgets;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.constants.ColumnFilterType;
import org.netxms.client.log.ColumnFilter;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.logviewer.widgets.ConditionEditor;
import org.netxms.nxmc.modules.logviewer.widgets.IntegerConditionEditor;
import org.xnap.commons.i18n.I18n;

public class IntegerConditionEditor
extends ConditionEditor {
    private final I18n i18n = LocalizationHelper.getI18n(IntegerConditionEditor.class);
    private final String[] OPERATIONS = new String[]{this.i18n.tr("EQUAL"), this.i18n.tr("NOT EQUAL"), "<", "<=", ">=", ">", this.i18n.tr("BETWEEN")};
    private Text value1;
    private Text value2;
    private Label andLabel;

    public IntegerConditionEditor(Composite parent) {
        super(parent);
    }

    protected String[] getOperations() {
        return this.OPERATIONS;
    }

    protected void createContent(ColumnFilter initialFilter) {
        Composite group = new Composite((Composite)this, 0);
        group.setBackground(this.getBackground());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        group.setLayoutData((Object)gd);
        this.value1 = new Text(group, 2048);
        this.value1.setText("0");
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 0x1000000;
        this.value1.setLayoutData((Object)gd);
        this.andLabel = new Label(group, 0);
        this.andLabel.setText(this.i18n.tr("  and  "));
        this.andLabel.setBackground(this.getBackground());
        this.andLabel.setVisible(false);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.andLabel.setLayoutData((Object)gd);
        this.value2 = new Text(group, 2048);
        this.value2.setText("0");
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 0x1000000;
        this.value2.setLayoutData((Object)gd);
        this.value2.setVisible(false);
        if (initialFilter != null) {
            switch (1.$SwitchMap$org$netxms$client$constants$ColumnFilterType[initialFilter.getType().ordinal()]) {
                case 1: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 1 : 0);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case 2: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 3 : 5);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case 3: {
                    this.setSelectedOperation(initialFilter.isNegated() ? 4 : 2);
                    this.value1.setText(Long.toString(initialFilter.getNumericValue()));
                    break;
                }
                case 4: {
                    this.setSelectedOperation(6);
                    this.andLabel.setVisible(true);
                    this.value2.setVisible(true);
                    this.value1.setText(Long.toString(initialFilter.getRangeFrom()));
                    this.value2.setText(Long.toString(initialFilter.getRangeTo()));
                    break;
                }
            }
        }
    }

    protected void operationSelectionChanged(int selectionIndex) {
        if (selectionIndex == 6) {
            this.andLabel.setVisible(true);
            this.value2.setVisible(true);
        } else {
            this.andLabel.setVisible(false);
            this.value2.setVisible(false);
        }
    }

    public ColumnFilter createFilter() {
        ColumnFilter filter;
        long n1;
        try {
            n1 = Long.parseLong(this.value1.getText());
        }
        catch (NumberFormatException e) {
            n1 = 0L;
        }
        switch (this.getSelectedOperation()) {
            case 1: {
                filter = new ColumnFilter(ColumnFilterType.EQUALS, n1);
                filter.setNegated(true);
                break;
            }
            case 2: {
                filter = new ColumnFilter(ColumnFilterType.LESS, n1);
                break;
            }
            case 3: {
                filter = new ColumnFilter(ColumnFilterType.GREATER, n1);
                filter.setNegated(true);
                break;
            }
            case 4: {
                filter = new ColumnFilter(ColumnFilterType.LESS, n1);
                filter.setNegated(true);
                break;
            }
            case 5: {
                filter = new ColumnFilter(ColumnFilterType.GREATER, n1);
                break;
            }
            case 6: {
                long n2;
                try {
                    n2 = Long.parseLong(this.value2.getText());
                }
                catch (NumberFormatException e) {
                    n2 = 0L;
                }
                filter = new ColumnFilter(n1, n2);
                break;
            }
            default: {
                filter = new ColumnFilter(ColumnFilterType.EQUALS, n1);
            }
        }
        return filter;
    }
}

