/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.dialogs;

import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.base.NXCommon;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class EditDCIImageRuleDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(EditDCIImageRuleDialog.class);
    private DCIImageRule rule;
    private Combo operation;
    private Text value;
    private Text comments;
    private UUID selectedImage;
    private Group conditionGroup;
    private ImageSelector image;

    public EditDCIImageRuleDialog(Shell parentShell, DCIImageRule rule) {
        super(parentShell);
        this.rule = rule;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit DCI Image Rule"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.conditionGroup = new Group(dialogArea, 0);
        this.conditionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.conditionGroup.setText(this.i18n.tr("Condition"));
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        this.conditionGroup.setLayout((Layout)condLayout);
        this.operation = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)this.i18n.tr("Operation"), (Object)"WidgetHelper::default_layout_data");
        this.operation.add(this.i18n.tr("< : less then"));
        this.operation.add(this.i18n.tr("<= : less then or equals"));
        this.operation.add(this.i18n.tr("== : equals"));
        this.operation.add(this.i18n.tr(">= : greater then or equals"));
        this.operation.add(this.i18n.tr("> : greater then"));
        this.operation.add(this.i18n.tr("!= : not equals"));
        this.operation.add(this.i18n.tr("like"));
        this.operation.add(this.i18n.tr("not like"));
        this.operation.select(this.rule.getComparisonType() != -1 ? this.rule.getComparisonType() : 0);
        this.value = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)120, (String)this.i18n.tr("Value"), (String)this.rule.getCompareValue(), (Object)"WidgetHelper::default_layout_data");
        this.comments = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)120, (String)this.i18n.tr("Comments"), (String)this.rule.getComment(), (Object)"WidgetHelper::default_layout_data");
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel(this.i18n.tr("Image"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.selectedImage = this.rule.getImage();
        this.image.setImageGuid(this.selectedImage, true);
        this.image.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void okPressed() {
        this.selectedImage = this.image.getImageGuid();
        if (this.selectedImage == null || this.selectedImage.equals(NXCommon.EMPTY_GUID)) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Image should be selected"));
            return;
        }
        String compareValue = this.value.getText();
        if (compareValue == null || compareValue.isEmpty()) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Value should not be empty"));
            return;
        }
        this.rule.setImage(this.selectedImage);
        this.rule.setComparisonType(this.operation.getSelectionIndex());
        this.rule.setCompareValue(compareValue);
        this.rule.setComment(this.comments.getText());
        super.okPressed();
    }
}

